/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views;

import org.phoenicis.javafx.components.application.control.ApplicationsFeaturePanel;
import org.phoenicis.javafx.components.container.control.ContainersFeaturePanel;
import org.phoenicis.javafx.components.installation.control.InstallationsFeaturePanel;
import org.phoenicis.javafx.components.library.control.LibraryFeaturePanel;
import org.phoenicis.javafx.settings.JavaFxSettingsConfiguration;
import org.phoenicis.javafx.themes.ThemeConfiguration;
import org.phoenicis.javafx.views.mainwindow.console.ConsoleTabFactory;
import org.phoenicis.javafx.views.mainwindow.containers.ContainersFilter;
import org.phoenicis.javafx.views.mainwindow.engines.EnginesView;
import org.phoenicis.javafx.views.mainwindow.installations.InstallationsFilter;
import org.phoenicis.javafx.views.mainwindow.library.ViewsConfigurationLibrary;
import org.phoenicis.javafx.views.mainwindow.settings.SettingsView;
import org.phoenicis.repository.RepositoryConfiguration;
import org.phoenicis.scripts.ScriptsConfiguration;
import org.phoenicis.settings.SettingsConfiguration;
import org.phoenicis.tools.ToolsConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ViewsConfigurationLibrary.class})
public class ViewsConfiguration {
    @Value(value="${application.name}")
    private String applicationName;
    @Value(value="${application.version:unknown}")
    private String applicationVersion;
    @Value(value="${application.gitRevision:unknown}")
    private String applicationGitRevision;
    @Value(value="${application.buildTimestamp:unknown}")
    private String applicationBuildTimestamp;
    @Value(value="${application.user.engines}")
    private String enginesPath;
    @Autowired
    private ViewsConfigurationLibrary viewsConfigurationLibrary;
    @Autowired
    private ThemeConfiguration themeConfiguration;
    @Autowired
    private ToolsConfiguration toolsConfiguration;
    @Autowired
    private SettingsConfiguration settingsConfiguration;
    @Autowired
    private ScriptsConfiguration scriptsConfiguration;
    @Autowired
    private JavaFxSettingsConfiguration javaFxSettingsConfiguration;
    @Autowired
    private RepositoryConfiguration repositoryConfiguration;

    @Bean
    public ApplicationsFeaturePanel viewApps() {
        ApplicationsFeaturePanel applicationsFeaturePanel = new ApplicationsFeaturePanel();
        applicationsFeaturePanel.setThemeManager(this.themeConfiguration.themeManager());
        applicationsFeaturePanel.setJavaFxSettingsManager(this.javaFxSettingsConfiguration.javaFxSettingsManager());
        applicationsFeaturePanel.setScriptInterpreter(this.scriptsConfiguration.scriptInterpreter());
        applicationsFeaturePanel.setFuzzySearchRatio(this.javaFxSettingsConfiguration.javaFxSettingsManager().getFuzzySearchRatio());
        applicationsFeaturePanel.setOperatingSystem(this.toolsConfiguration.operatingSystemFetcher().fetchCurrentOperationSystem());
        return applicationsFeaturePanel;
    }

    @Bean
    public EnginesView viewEngines() {
        return new EnginesView(this.themeConfiguration.themeManager(), this.enginesPath, this.javaFxSettingsConfiguration.javaFxSettingsManager());
    }

    @Bean
    public ContainersFeaturePanel viewContainers() {
        ContainersFeaturePanel containersFeaturePanel = new ContainersFeaturePanel();
        containersFeaturePanel.setJavaFxSettingsManager(this.javaFxSettingsConfiguration.javaFxSettingsManager());
        ContainersFilter containersFilter = new ContainersFilter();
        containersFeaturePanel.setFilter(containersFilter);
        return containersFeaturePanel;
    }

    @Bean
    public InstallationsFeaturePanel viewInstallations() {
        InstallationsFeaturePanel installationsFeaturePanel = new InstallationsFeaturePanel();
        installationsFeaturePanel.setJavaFxSettingsManager(this.javaFxSettingsConfiguration.javaFxSettingsManager());
        InstallationsFilter installationsFilter = new InstallationsFilter();
        installationsFeaturePanel.setFilter(installationsFilter);
        installationsFeaturePanel.setInitialized(true);
        return installationsFeaturePanel;
    }

    @Bean
    public SettingsView viewSettings() {
        return new SettingsView(this.themeConfiguration.themeManager(), this.applicationName, this.applicationVersion, this.applicationGitRevision, this.applicationBuildTimestamp, this.toolsConfiguration.opener(), this.settingsConfiguration.settingsManager(), this.repositoryConfiguration.repositoryLocationLoader(), this.javaFxSettingsConfiguration.javaFxSettingsManager(), this.repositoryConfiguration.repositoryManager());
    }

    @Bean
    public LibraryFeaturePanel viewLibrary() {
        return this.viewsConfigurationLibrary.viewLibrary();
    }

    @Bean
    public ConsoleTabFactory consoleTabFactory() {
        return this.viewsConfigurationLibrary.consoleTabFactory();
    }
}

