/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.utils;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class SwitchBinding<V, C>
extends ObjectBinding<C> {
    private final ObjectProperty<V> value;
    private final C defaultCase;
    private final Map<Class<? extends V>, Function<V, C>> cases;

    private SwitchBinding(ObjectProperty<V> value, C defaultCase, Map<Class<? extends V>, Function<V, C>> cases) {
        this.value = value;
        this.defaultCase = defaultCase;
        this.cases = cases;
        this.initialize();
    }

    public static <V, C> SwitchBindingBuilder<V, C> builder() {
        return new SwitchBindingBuilder();
    }

    public static <V, C> SwitchBindingBuilder<V, C> builder(ObjectProperty<V> value) {
        return new SwitchBindingBuilder(value);
    }

    private void initialize() {
        this.bind(new Observable[]{this.value});
    }

    protected C computeValue() {
        Object current = this.value.getValue();
        Function<V, C> result = this.defaultCase != null ? this.cases.getOrDefault(current.getClass(), x -> this.defaultCase) : this.cases.get(current.getClass());
        return result.apply(current);
    }

    public void dispose() {
        super.unbind(new Observable[]{this.value});
    }

    public ObservableList<?> getDependencies() {
        return FXCollections.singletonObservableList(this.value);
    }

    public static class SwitchBindingBuilder<V, C> {
        private final Map<Class<? extends V>, Function<V, C>> cases = new HashMap<Class<? extends V>, Function<V, C>>();
        private ObjectProperty<V> value;
        private C defaultCase;

        public SwitchBindingBuilder() {
        }

        public SwitchBindingBuilder(ObjectProperty<V> value) {
            this();
            this.value = value;
        }

        public SwitchBindingBuilder<V, C> withValue(ObjectProperty<V> value) {
            this.value = value;
            return this;
        }

        public <K extends V> SwitchBindingBuilder<V, C> withCase(Class<K> guard, Function<K, C> result) {
            this.cases.put(guard, result);
            return this;
        }

        public SwitchBindingBuilder<V, C> withDefaultCase(C result) {
            this.defaultCase = result;
            return this;
        }

        public SwitchBindingBuilder<V, C> withEmptyDefaultCase() {
            return this.withDefaultCase(null);
        }

        public SwitchBinding<V, C> build() {
            return new SwitchBinding<V, C>(this.value, this.defaultCase, ImmutableMap.copyOf(this.cases));
        }
    }
}

