/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.utils;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;

public class CollectionBindings {
    public static <I, O> ObservableList<O> mapToList(ObservableValue<I> property, Function<I, ? extends Collection<O>> converter) {
        ObservableList result = FXCollections.observableArrayList();
        InvalidationListener listener = invalidation -> {
            Object input = property.getValue();
            if (input != null) {
                result.setAll((Collection)converter.apply(input));
            } else {
                result.clear();
            }
        };
        property.addListener(listener);
        listener.invalidated(property);
        return result;
    }

    public static <I, O1, O2> ObservableMap<O1, O2> mapToMap(ObservableValue<I> property, Function<I, Map<O1, O2>> converter) {
        ObservableMap result = FXCollections.observableHashMap();
        InvalidationListener listener = invalidation -> {
            Object input = property.getValue();
            result.clear();
            if (input != null) {
                result.putAll((Map)converter.apply(input));
            }
        };
        property.addListener(listener);
        listener.invalidated(property);
        return result;
    }
}

