/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.themes;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableStringValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.phoenicis.javafx.collections.ConcatenatedList;
import org.phoenicis.javafx.themes.Theme;
import org.phoenicis.javafx.themes.Themes;
import org.phoenicis.javafx.utils.CollectionBindings;
import org.phoenicis.javafx.utils.ObjectBindings;
import org.phoenicis.javafx.utils.StringBindings;

public class ThemeManager {
    private final ObjectProperty<Theme> currentTheme;
    private final ObservableList<String> defaultCategoryIconsStylesheets;
    private final ObservableList<String> defaultLibraryCategoryIconsStylesheets;
    private final ObservableList<String> defaultEngineIconsStylesheets;
    private final ObservableList<String> stylesheets;
    private final StringBinding webEngineStylesheet;

    public ThemeManager(ObjectProperty<Theme> currentTheme) {
        this.currentTheme = currentTheme;
        this.defaultCategoryIconsStylesheets = FXCollections.observableArrayList();
        this.defaultLibraryCategoryIconsStylesheets = FXCollections.observableArrayList();
        this.defaultEngineIconsStylesheets = FXCollections.observableArrayList();
        ObservableList baseStylesheets = FXCollections.observableList(this.getStylesheets(Themes.STANDARD));
        ObservableList currentStylesheets = CollectionBindings.mapToList(currentTheme, this::getNonStandardStylesheets);
        this.stylesheets = ConcatenatedList.create((ObservableList[])new ObservableList[]{this.defaultCategoryIconsStylesheets, this.defaultLibraryCategoryIconsStylesheets, this.defaultEngineIconsStylesheets, baseStylesheets, currentStylesheets});
        ObjectBinding<Optional> currentWebEngineUri = ObjectBindings.map(currentTheme, theme -> theme.getResourceUri("description.css"));
        StringBinding currentWebEngineStylesheet = StringBindings.map(currentWebEngineUri, uri -> uri.map(URI::toString).orElse(null));
        this.webEngineStylesheet = Bindings.when((ObservableBooleanValue)Bindings.isNull((ObservableObjectValue)currentWebEngineStylesheet)).then(Themes.STANDARD.getResourceUri("description.css").map(URI::toString).orElseThrow(() -> new IllegalStateException("Standard theme contains no \"description.css\" file"))).otherwise((ObservableStringValue)currentWebEngineStylesheet);
    }

    public ThemeManager(Theme currentTheme) {
        this((ObjectProperty<Theme>)new SimpleObjectProperty((Object)currentTheme));
    }

    public Theme getCurrentTheme() {
        return (Theme)this.currentTheme.get();
    }

    public void setCurrentTheme(Theme theme) {
        this.currentTheme.set((Object)theme);
    }

    public void setDefaultCategoryIconsCss(String defaultCategoryIconsCss) {
        this.defaultCategoryIconsStylesheets.setAll((Object[])new String[]{defaultCategoryIconsCss});
    }

    public void setDefaultLibraryCategoryIconsCss(String defaultLibraryCategoryIconsCss) {
        this.defaultLibraryCategoryIconsStylesheets.setAll((Object[])new String[]{defaultLibraryCategoryIconsCss});
    }

    public void setDefaultEngineIconsCss(String defaultEngineIconsCss) {
        this.defaultEngineIconsStylesheets.setAll((Object[])new String[]{defaultEngineIconsCss});
    }

    public StringBinding webEngineStylesheetProperty() {
        return this.webEngineStylesheet;
    }

    public ObservableList<String> getStylesheets() {
        return this.stylesheets;
    }

    private List<String> getStylesheets(Theme theme) {
        if (theme == null) {
            return Collections.emptyList();
        }
        List<String> themeResourceFiles = List.of("main.css", "buttons.css");
        return themeResourceFiles.stream().map(theme::getResourceUri).flatMap(Optional::stream).map(URI::toString).collect(Collectors.toList());
    }

    private List<String> getNonStandardStylesheets(Theme theme) {
        return Themes.STANDARD == theme ? Collections.emptyList() : this.getStylesheets(theme);
    }
}

