/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.themes;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.javafx.themes.Theme;

public class ClasspathTheme
extends Theme {
    private final String classpathToTheme;

    public ClasspathTheme(String name, String shortName, String classpathToTheme) {
        super(name, shortName);
        this.classpathToTheme = classpathToTheme;
    }

    @Override
    public Optional<URI> getResourceUri(String resource) {
        String resourcePath = this.classpathToTheme.endsWith("/") ? this.classpathToTheme + resource : this.classpathToTheme + "/" + resource;
        URL resourceUrl = this.getClass().getResource(resourcePath);
        return Optional.ofNullable(resourceUrl).map(url -> {
            try {
                return url.toURI();
            }
            catch (URISyntaxException e) {
                return null;
            }
        });
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("shortName", (Object)this.getShortName()).append("classpathToTheme", (Object)this.classpathToTheme).toString();
    }
}

