/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.settings;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetType;
import org.phoenicis.javafx.settings.JavaFxSetting;
import org.phoenicis.javafx.settings.JavaFxSettings;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.DefaultPropertiesPersister;

public class JavaFxSettingsManager {
    @Value(value="${application.theme}")
    private String theme;
    @Value(value="${application.scale}")
    private double scale;
    @Value(value="${application.advancedMode}")
    private boolean advancedMode;
    @Value(value="${application.viewsource}")
    private boolean viewScriptSource;
    @Value(value="${application.windowWidth}")
    private double windowWidth;
    @Value(value="${application.windowHeight}")
    private double windowHeight;
    @Value(value="${application.windowMaximized}")
    private boolean windowMaximized;
    @Value(value="${application.appsListType}")
    private ListWidgetType appsListType;
    @Value(value="${application.containersListType}")
    private ListWidgetType containersListType;
    @Value(value="${application.enginesListType}")
    private ListWidgetType enginesListType;
    @Value(value="${application.installationsListType}")
    private ListWidgetType installationsListType;
    @Value(value="${application.libraryListType}")
    private ListWidgetType libraryListType;
    @Value(value="${application.fuzzySearchRatio}")
    private double fuzzySearchRatio;
    private String settingsFileName = "javafx.properties";

    public JavaFxSettingsManager(String settingsFileName) {
        this.settingsFileName = settingsFileName;
    }

    public void save() {
        JavaFxSettings javaFxSettings = this.load();
        try (FileOutputStream outputStream = new FileOutputStream(new File(this.settingsFileName));){
            DefaultPropertiesPersister persister = new DefaultPropertiesPersister();
            persister.store(javaFxSettings.getProperties(), (OutputStream)outputStream, "Phoenicis JavaFX User JavaFxSettings");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JavaFxSettings load() {
        JavaFxSettings javaFxSettings = new JavaFxSettings();
        javaFxSettings.set(JavaFxSetting.THEME, this.theme);
        javaFxSettings.set(JavaFxSetting.SCALE, this.scale);
        javaFxSettings.set(JavaFxSetting.ADVANCED_MODE, String.valueOf(this.advancedMode));
        javaFxSettings.set(JavaFxSetting.VIEW_SOURCE, String.valueOf(this.viewScriptSource));
        javaFxSettings.set(JavaFxSetting.WINDOW_HEIGHT, this.windowHeight);
        javaFxSettings.set(JavaFxSetting.WINDOW_WIDTH, this.windowWidth);
        javaFxSettings.set(JavaFxSetting.WINDOW_MAXIMIZED, String.valueOf(this.windowMaximized));
        javaFxSettings.set(JavaFxSetting.APPS_LIST_TYPE, String.valueOf((Object)this.appsListType));
        javaFxSettings.set(JavaFxSetting.CONTAINERS_LIST_TYPE, String.valueOf((Object)this.containersListType));
        javaFxSettings.set(JavaFxSetting.ENGINES_LIST_TYPE, String.valueOf((Object)this.enginesListType));
        javaFxSettings.set(JavaFxSetting.INSTALLATIONS_LIST_TYPE, String.valueOf((Object)this.libraryListType));
        javaFxSettings.set(JavaFxSetting.LIBRARY_LIST_TYPE, String.valueOf((Object)this.libraryListType));
        javaFxSettings.set(JavaFxSetting.FUZZY_SEARCH_RATIO, this.fuzzySearchRatio);
        return javaFxSettings;
    }

    public void restoreDefault() {
        new File(this.settingsFileName).deleteOnExit();
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public boolean isAdvancedMode() {
        return this.advancedMode;
    }

    public void setAdvancedMode(boolean advancedMode) {
        this.advancedMode = advancedMode;
    }

    public boolean isViewScriptSource() {
        return this.viewScriptSource;
    }

    public void setViewScriptSource(boolean viewScriptSource) {
        this.viewScriptSource = viewScriptSource;
    }

    public void setWindowWidth(double windowWidth) {
        this.windowWidth = windowWidth;
    }

    public double getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowHeight(double windowHeight) {
        this.windowHeight = windowHeight;
    }

    public double getWindowHeight() {
        return this.windowHeight;
    }

    public void setWindowMaximized(boolean windowMaximized) {
        this.windowMaximized = windowMaximized;
    }

    public boolean isWindowMaximized() {
        return this.windowMaximized;
    }

    public void setAppsListType(ListWidgetType appsListType) {
        this.appsListType = appsListType;
    }

    public ListWidgetType getAppsListType() {
        return this.appsListType;
    }

    public void setContainersListType(ListWidgetType containersListType) {
        this.containersListType = containersListType;
    }

    public ListWidgetType getContainersListType() {
        return this.containersListType;
    }

    public void setEnginesListType(ListWidgetType enginesListType) {
        this.enginesListType = enginesListType;
    }

    public ListWidgetType getEnginesListType() {
        return this.enginesListType;
    }

    public void setInstallationsListType(ListWidgetType installationsListType) {
        this.installationsListType = installationsListType;
    }

    public ListWidgetType getInstallationsListType() {
        return this.installationsListType;
    }

    public void setLibraryListType(ListWidgetType libraryListType) {
        this.libraryListType = libraryListType;
    }

    public ListWidgetType getLibraryListType() {
        return this.libraryListType;
    }

    public void setFuzzySearchRatio(double fuzzySearchRatio) {
        this.fuzzySearchRatio = fuzzySearchRatio;
    }

    public double getFuzzySearchRatio() {
        return this.fuzzySearchRatio;
    }
}

