/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.dialogs;

import javafx.stage.Window;
import org.phoenicis.javafx.dialogs.ConfirmDialog;

public class SimpleConfirmDialog
extends ConfirmDialog {
    private SimpleConfirmDialog() {
        this.initialise();
    }

    public static ConfirmDialogBuilder builder() {
        return new ConfirmDialogBuilder();
    }

    private void initialise() {
        this.getDialogPane().getStyleClass().add((Object)"simple-confirm-dialog");
        this.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
    }

    public static class ConfirmDialogBuilder {
        private String title;
        private String message;
        private Runnable yesCallback;
        private Runnable noCallback;
        private Window owner;
        private boolean resizable = true;

        public ConfirmDialogBuilder withTitle(String title) {
            this.title = title;
            return this;
        }

        public ConfirmDialogBuilder withMessage(String message) {
            this.message = message;
            return this;
        }

        public ConfirmDialogBuilder withYesCallback(Runnable yesCallback) {
            this.yesCallback = yesCallback;
            return this;
        }

        public ConfirmDialogBuilder withNoCallback(Runnable noCallback) {
            this.noCallback = noCallback;
            return this;
        }

        public ConfirmDialogBuilder withOwner(Window owner) {
            this.owner = owner;
            return this;
        }

        public ConfirmDialogBuilder withResizable(boolean resizable) {
            this.resizable = resizable;
            return this;
        }

        public SimpleConfirmDialog build() {
            SimpleConfirmDialog dialog = new SimpleConfirmDialog();
            dialog.initOwner(this.owner);
            dialog.setTitle(this.title);
            dialog.setHeaderText(this.title);
            dialog.setContentText(this.message);
            dialog.setYesCallback(this.yesCallback);
            dialog.setNoCallback(this.noCallback);
            dialog.setResizable(this.resizable);
            return dialog;
        }
    }
}

