/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.dialogs;

import java.util.List;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.stage.Window;
import org.phoenicis.javafx.dialogs.ConfirmDialog;

public class ListConfirmDialog
extends ConfirmDialog {
    private final ObservableList<String> confirmItems = FXCollections.observableArrayList();

    private ListConfirmDialog() {
        this.initialise();
    }

    public static ListConfirmDialogBuilder builder() {
        return new ListConfirmDialogBuilder();
    }

    private void initialise() {
        this.getDialogPane().getStyleClass().add((Object)"list-confirm-dialog");
        ListView confirmList = new ListView(this.getConfirmItems());
        confirmList.getStyleClass().add((Object)"confirm-list");
        confirmList.setEditable(false);
        this.getDialogPane().setExpandableContent((Node)confirmList);
        this.getDialogPane().expandedProperty().addListener(observable -> Platform.runLater(() -> {
            this.getDialogPane().requestLayout();
            Window window = this.getDialogPane().getScene().getWindow();
            window.sizeToScene();
        }));
        this.getDialogPane().setExpanded(true);
        this.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
    }

    public ObservableList<String> getConfirmItems() {
        return this.confirmItems;
    }

    public static class ListConfirmDialogBuilder {
        private String title;
        private String message;
        private List<String> confirmItems;
        private Runnable yesCallback;
        private Runnable noCallback;
        private Window owner;
        private boolean resizable = true;

        public ListConfirmDialogBuilder withTitle(String title) {
            this.title = title;
            return this;
        }

        public ListConfirmDialogBuilder withMessage(String message) {
            this.message = message;
            return this;
        }

        public ListConfirmDialogBuilder withConfirmItems(List<String> confirmItems) {
            this.confirmItems = confirmItems;
            return this;
        }

        public ListConfirmDialogBuilder withYesCallback(Runnable yesCallback) {
            this.yesCallback = yesCallback;
            return this;
        }

        public ListConfirmDialogBuilder withNoCallback(Runnable noCallback) {
            this.noCallback = noCallback;
            return this;
        }

        public ListConfirmDialogBuilder withOwner(Window owner) {
            this.owner = owner;
            return this;
        }

        public ListConfirmDialogBuilder withResizable(boolean resizable) {
            this.resizable = resizable;
            return this;
        }

        public ListConfirmDialog build() {
            ListConfirmDialog dialog = new ListConfirmDialog();
            dialog.initOwner(this.owner);
            dialog.setTitle(this.title);
            dialog.setHeaderText(this.title);
            dialog.setContentText(this.message);
            dialog.setYesCallback(this.yesCallback);
            dialog.setNoCallback(this.noCallback);
            dialog.setResizable(this.resizable);
            if (this.confirmItems != null) {
                dialog.getConfirmItems().setAll(this.confirmItems);
            }
            return dialog;
        }
    }
}

