/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.dialogs;

import javafx.scene.control.Alert;
import javafx.stage.Window;

public class InformationDialog
extends Alert {
    private InformationDialog() {
        super(Alert.AlertType.INFORMATION);
    }

    public static InformationDialogBuilder builder() {
        return new InformationDialogBuilder();
    }

    public static class InformationDialogBuilder {
        private String title;
        private String message;
        private Window owner;
        private boolean resizable;

        public InformationDialogBuilder withTitle(String title) {
            this.title = title;
            return this;
        }

        public InformationDialogBuilder withMessage(String message) {
            this.message = message;
            return this;
        }

        public InformationDialogBuilder withOwner(Window owner) {
            this.owner = owner;
            return this;
        }

        public InformationDialogBuilder withResizable(boolean resizable) {
            this.resizable = resizable;
            return this;
        }

        public InformationDialog build() {
            InformationDialog dialog = new InformationDialog();
            dialog.initOwner(this.owner);
            dialog.setTitle(this.title);
            dialog.setHeaderText(this.title);
            dialog.setContentText(this.message);
            dialog.setResizable(this.resizable);
            dialog.getDialogPane().setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            return dialog;
        }
    }
}

