/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.dialogs;

import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.utils.StringBindings;

public class ErrorDialog
extends Alert {
    private final ObjectProperty<Exception> exception = new SimpleObjectProperty();

    private ErrorDialog() {
        super(Alert.AlertType.ERROR);
        this.initialise();
    }

    public static ErrorDialogBuilder builder() {
        return new ErrorDialogBuilder();
    }

    private void initialise() {
        this.getDialogPane().getStyleClass().addAll((Object[])new String[]{"phoenicis-dialog", "error-dialog"});
        this.contentTextProperty().bind((ObservableValue)StringBindings.map(this.exceptionProperty(), Throwable::getMessage));
        this.getDialogPane().setExpandableContent((Node)this.createExpandableContent());
        this.getDialogPane().expandedProperty().addListener(observable -> Platform.runLater(() -> {
            this.getDialogPane().requestLayout();
            Window window = this.getDialogPane().getScene().getWindow();
            window.sizeToScene();
        }));
        this.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
    }

    private VBox createExpandableContent() {
        Label label = new Label((String)Localisation.tr((Object)"Stack trace:"));
        TextArea textArea = new TextArea();
        textArea.setEditable(false);
        textArea.textProperty().bind((ObservableValue)StringBindings.map(this.exceptionProperty(), ExceptionUtils::getFullStackTrace));
        VBox.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        VBox container = new VBox(new Node[]{label, textArea});
        container.setFillWidth(true);
        return container;
    }

    public Exception getException() {
        return (Exception)this.exception.get();
    }

    public ObjectProperty<Exception> exceptionProperty() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception.set((Object)exception);
    }

    public static class ErrorDialogBuilder {
        private String message;
        private Exception exception;
        private Window owner;
        private boolean resizable = true;

        public ErrorDialogBuilder withMessage(String message) {
            this.message = message;
            return this;
        }

        public ErrorDialogBuilder withException(Exception exception) {
            this.exception = exception;
            return this;
        }

        public ErrorDialogBuilder withOwner(Window owner) {
            this.owner = owner;
            return this;
        }

        public ErrorDialogBuilder withResizable(boolean resizable) {
            this.resizable = resizable;
            return this;
        }

        public ErrorDialog build() {
            ErrorDialog dialog = new ErrorDialog();
            dialog.setTitle((String)Localisation.tr((Object)"Error"));
            dialog.setHeaderText(this.message);
            dialog.setException(this.exception);
            dialog.initOwner(this.owner);
            dialog.setResizable(this.resizable);
            return dialog;
        }
    }
}

