/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.dialogs;

import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;

public abstract class ConfirmDialog
extends Alert {
    private final ObjectProperty<Runnable> yesCallback = new SimpleObjectProperty();
    private final ObjectProperty<Runnable> noCallback = new SimpleObjectProperty();

    protected ConfirmDialog() {
        super(Alert.AlertType.CONFIRMATION);
        this.getDialogPane().getStyleClass().add((Object)"phoenicis-dialog");
    }

    public void showAndCallback() {
        ButtonType result = this.showAndWait().orElse(ButtonType.CANCEL);
        if (result == ButtonType.OK) {
            Optional.ofNullable(this.getYesCallback()).ifPresent(Runnable::run);
        } else {
            Optional.ofNullable(this.getNoCallback()).ifPresent(Runnable::run);
        }
    }

    public Runnable getYesCallback() {
        return (Runnable)this.yesCallback.get();
    }

    public ObjectProperty<Runnable> yesCallbackProperty() {
        return this.yesCallback;
    }

    public void setYesCallback(Runnable yesCallback) {
        this.yesCallback.set((Object)yesCallback);
    }

    public Runnable getNoCallback() {
        return (Runnable)this.noCallback.get();
    }

    public ObjectProperty<Runnable> noCallbackProperty() {
        return this.noCallback;
    }

    public void setNoCallback(Runnable noCallback) {
        this.noCallback.set((Object)noCallback);
    }
}

