/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.controller.library.console;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.phoenicis.javafx.views.mainwindow.console.ConsoleTab;
import org.phoenicis.javafx.views.mainwindow.console.ConsoleTabFactory;
import org.phoenicis.javafx.views.mainwindow.console.ConsoleTextType;
import org.phoenicis.scripts.interpreter.ScriptInterpreter;
import org.phoenicis.scripts.session.InteractiveScriptSession;

public class ConsoleController {
    private final ConsoleTabFactory consoleTabFactory;
    private final ScriptInterpreter scriptInterpreter;

    public ConsoleController(ConsoleTabFactory consoleTabFactory, ScriptInterpreter scriptInterpreter) {
        this.consoleTabFactory = consoleTabFactory;
        this.scriptInterpreter = scriptInterpreter;
    }

    public ConsoleTab createConsole() {
        ConsoleTab consoleTab = this.consoleTabFactory.createInstance();
        InteractiveScriptSession interactiveScriptSession = this.scriptInterpreter.createInteractiveSession();
        consoleTab.setOnSendCommand(command -> {
            consoleTab.appendTextToConsole("> " + command + "\n", ConsoleTextType.NORMAL);
            consoleTab.disableCommand();
            interactiveScriptSession.eval(command, result -> {
                consoleTab.appendTextToConsole((String)(result == null ? "null\n" : result.toString() + "\n"));
                consoleTab.enableCommand();
            }, error -> {
                consoleTab.appendTextToConsole(ExceptionUtils.getFullStackTrace((Throwable)error), ConsoleTextType.ERROR);
                consoleTab.enableCommand();
            });
        });
        return consoleTab;
    }
}

