/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.controller.library;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.components.library.control.LibraryFeaturePanel;
import org.phoenicis.javafx.components.library.skin.LibrarySidebarToggleGroupSkin;
import org.phoenicis.javafx.dialogs.ErrorDialog;
import org.phoenicis.javafx.themes.ThemeManager;
import org.phoenicis.library.LibraryManager;
import org.phoenicis.library.dto.ShortcutCategoryDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryController {
    private final Logger LOGGER = LoggerFactory.getLogger(LibraryController.class);
    private final LibraryFeaturePanel libraryView;
    private final LibraryManager libraryManager;
    private final ThemeManager themeManager;

    public LibraryController(LibraryFeaturePanel libraryView, LibraryManager libraryManager, ThemeManager themeManager) {
        this.libraryView = libraryView;
        this.libraryManager = libraryManager;
        this.themeManager = themeManager;
        this.libraryManager.setOnUpdate(this::populate);
        this.libraryManager.refresh();
    }

    private void populate() {
        List categories = this.libraryManager.fetchShortcuts();
        this.setDefaultLibraryCategoryIcons(categories);
        Platform.runLater(() -> {
            this.getView().getCategories().setAll((Collection)categories);
            this.getView().setInitialized(true);
        });
    }

    private void showError(Exception e) {
        Platform.runLater(() -> {
            ErrorDialog errorDialog = ErrorDialog.builder().withOwner(this.getView().getScene().getWindow()).withException(e).withMessage((String)Localisation.tr((Object)"Unable to load library, please try again.")).build();
            errorDialog.showAndWait();
        });
    }

    private void setDefaultLibraryCategoryIcons(List<ShortcutCategoryDTO> categories) {
        Platform.runLater(() -> {
            try {
                StringBuilder cssBuilder = new StringBuilder();
                for (ShortcutCategoryDTO category : categories) {
                    cssBuilder.append("#" + LibrarySidebarToggleGroupSkin.getToggleButtonId(category.getId()) + "{\n");
                    String categoryIconPath = Optional.ofNullable(category.getIcon()).map(categoryIcon -> categoryIcon.toString()).orElse("/org/phoenicis/javafx/views/common/phoenicis.png");
                    cssBuilder.append(String.format("-fx-background-image: url('%s');\n", categoryIconPath));
                    cssBuilder.append("}\n");
                }
                String css = cssBuilder.toString();
                Path temp = Files.createTempFile("defaultLibraryCategoryIcons", ".css", new FileAttribute[0]).toAbsolutePath();
                File tempFile = temp.toFile();
                tempFile.deleteOnExit();
                Files.write(temp, css.getBytes(), new OpenOption[0]);
                String defaultLibraryCategoryIconsCss = temp.toUri().toString();
                this.themeManager.setDefaultLibraryCategoryIconsCss(defaultLibraryCategoryIconsCss);
            }
            catch (IOException e) {
                this.LOGGER.warn("Could not set default category icons.", (Throwable)e);
            }
        });
    }

    public LibraryFeaturePanel getView() {
        return this.libraryView;
    }
}

