/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.controller.engines;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.engines.Engine;
import org.phoenicis.engines.EnginesManager;
import org.phoenicis.engines.dto.EngineCategoryDTO;
import org.phoenicis.engines.dto.EngineSubCategoryDTO;
import org.phoenicis.javafx.controller.apps.AppsController;
import org.phoenicis.javafx.dialogs.ErrorDialog;
import org.phoenicis.javafx.dialogs.SimpleConfirmDialog;
import org.phoenicis.javafx.themes.ThemeManager;
import org.phoenicis.javafx.views.mainwindow.engines.EnginesView;
import org.phoenicis.repository.RepositoryManager;
import org.phoenicis.repository.dto.CategoryDTO;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnginesController {
    private final Logger LOGGER = LoggerFactory.getLogger(AppsController.class);
    private final EnginesView enginesView;
    private final RepositoryManager repositoryManager;
    private final EnginesManager enginesManager;
    private ThemeManager themeManager;
    private RepositoryDTO repositoryCache;
    private Map<String, Engine> enginesCache = new HashMap<String, Engine>();
    private Map<String, List<EngineSubCategoryDTO>> versionsCache = new HashMap<String, List<EngineSubCategoryDTO>>();
    private boolean firstViewSelection = true;

    public EnginesController(EnginesView enginesView, RepositoryManager repositoryManager, EnginesManager enginesManager, ThemeManager themeManager) {
        this.enginesView = enginesView;
        this.repositoryManager = repositoryManager;
        this.enginesManager = enginesManager;
        this.themeManager = themeManager;
        this.enginesView.setOnSelectEngineCategory(engineCategoryDTO -> {
            String engineId = engineCategoryDTO.getName().toLowerCase();
            if (!this.versionsCache.containsKey(engineId)) {
                this.enginesManager.fetchAvailableVersions(engineId, versions -> {
                    this.versionsCache.put(engineId, (List<EngineSubCategoryDTO>)versions);
                    this.enginesView.updateVersions((EngineCategoryDTO)engineCategoryDTO, (List<EngineSubCategoryDTO>)versions);
                }, e -> Platform.runLater(() -> {
                    ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error")).withException((Exception)e).withOwner(this.enginesView.getContent().getScene().getWindow()).build();
                    errorDialog.showAndWait();
                }));
            }
        });
        this.enginesView.setOnInstallEngine(engineDTO -> {
            SimpleConfirmDialog confirmMessage = SimpleConfirmDialog.builder().withTitle(Localisation.tr((String)"Install {0}", (Object)engineDTO.getVersion())).withMessage(Localisation.tr((String)"Are you sure you want to install {0}?", (Object)engineDTO.getVersion())).withOwner(enginesView.getContent().getScene().getWindow()).withResizable(true).withYesCallback(() -> this.enginesManager.getEngine(engineDTO.getId(), engine -> {
                engine.install(engineDTO.getSubCategory(), engineDTO.getVersion());
                this.versionsCache.remove(engineDTO.getId());
                this.forceViewUpdate();
            }, e -> Platform.runLater(() -> {
                ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error")).withException((Exception)e).withOwner(this.enginesView.getContent().getScene().getWindow()).build();
                errorDialog.showAndWait();
            }))).build();
            confirmMessage.showAndCallback();
        });
        this.enginesView.setOnDeleteEngine(engineDTO -> {
            SimpleConfirmDialog confirmMessage = SimpleConfirmDialog.builder().withTitle(Localisation.tr((String)"Delete {0}", (Object)engineDTO.getVersion())).withMessage(Localisation.tr((String)"Are you sure you want to delete {0}?", (Object)engineDTO.getVersion())).withOwner(enginesView.getContent().getScene().getWindow()).withResizable(true).withYesCallback(() -> this.enginesManager.getEngine(engineDTO.getId(), engine -> {
                engine.delete(engineDTO.getSubCategory(), engineDTO.getVersion());
                this.versionsCache.remove(engineDTO.getId());
                this.forceViewUpdate();
            }, e -> Platform.runLater(() -> {
                ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error")).withException((Exception)e).withOwner(this.enginesView.getContent().getScene().getWindow()).build();
                errorDialog.showAndWait();
            }))).build();
            confirmMessage.showAndCallback();
        });
        this.enginesView.setOnSelectionChanged(event -> {
            if (this.enginesView.isSelected() && this.firstViewSelection) {
                this.repositoryManager.addCallbacks(repositoryDTO -> this.enginesManager.fetchAvailableEngines(repositoryDTO, engines -> this.populateView((RepositoryDTO)repositoryDTO, (Map<String, Engine>)engines), e -> Platform.runLater(() -> enginesView.showFailure((String)Localisation.tr((Object)"Loading engines failed."), Optional.of(e)))), e -> Platform.runLater(() -> enginesView.showFailure((String)Localisation.tr((Object)"Loading engines failed."), Optional.of(e))));
                this.repositoryManager.triggerCallbacks();
                this.firstViewSelection = false;
            }
        });
    }

    public EnginesView getView() {
        return this.enginesView;
    }

    private void populateView(RepositoryDTO repositoryDTO, Map<String, Engine> engines) {
        this.repositoryCache = repositoryDTO;
        this.enginesCache = engines;
        Platform.runLater(this.enginesView::showWait);
        List categoryDTOS = repositoryDTO.getTypes().stream().filter(type -> type.getId().equals("engines")).flatMap(type -> type.getCategories().stream()).collect(Collectors.toList());
        Platform.runLater(() -> this.setDefaultEngineIcons(categoryDTOS));
        ArrayDeque<EngineCategoryDTO> engineCategories = new ArrayDeque<EngineCategoryDTO>(this.enginesManager.getAvailableEngines(categoryDTOS));
        this.fetchEngineSubcategories(engineCategories, (Map<EngineCategoryDTO, List<EngineSubCategoryDTO>>)ImmutableMap.of(), subcategoryMap -> {
            List categories = subcategoryMap.entrySet().stream().map(entry -> new EngineCategoryDTO.Builder((EngineCategoryDTO)entry.getKey()).withSubCategories((List)entry.getValue()).build()).collect(Collectors.toList());
            Platform.runLater(() -> this.enginesView.populate(categories, engines));
        });
    }

    private void fetchEngineSubcategories(Queue<EngineCategoryDTO> engineCategories, Map<EngineCategoryDTO, List<EngineSubCategoryDTO>> result, Consumer<Map<EngineCategoryDTO, List<EngineSubCategoryDTO>>> callback) {
        ArrayDeque<EngineCategoryDTO> queue = new ArrayDeque<EngineCategoryDTO>(engineCategories);
        if (queue.isEmpty()) {
            callback.accept(result);
        } else {
            EngineCategoryDTO engineCategory = (EngineCategoryDTO)queue.poll();
            String engineId = engineCategory.getName().toLowerCase();
            this.enginesManager.fetchAvailableVersions(engineId, versions -> this.fetchEngineSubcategories(queue, (Map<EngineCategoryDTO, List<EngineSubCategoryDTO>>)ImmutableMap.builder().putAll(result).put((Object)engineCategory, versions).build(), callback), e -> Platform.runLater(() -> {
                ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error")).withException((Exception)e).withOwner(this.enginesView.getContent().getScene().getWindow()).build();
                errorDialog.showAndWait();
            }));
        }
    }

    private void forceViewUpdate() {
        this.populateView(this.repositoryCache, this.enginesCache);
    }

    private void setDefaultEngineIcons(List<CategoryDTO> categoryDTOS) {
        try {
            StringBuilder cssBuilder = new StringBuilder();
            for (CategoryDTO category : categoryDTOS) {
                cssBuilder.append("#" + category.getName().toLowerCase() + "Button{\n");
                URI categoryIcon = category.getIcon();
                if (categoryIcon == null) {
                    cssBuilder.append("-fx-background-image: url('/org/phoenicis/javafx/views/common/phoenicis.png');\n");
                } else {
                    cssBuilder.append("-fx-background-image: url('" + categoryIcon + "');\n");
                }
                cssBuilder.append("}\n");
            }
            String css = cssBuilder.toString();
            Path temp = Files.createTempFile("defaultEngineIcons", ".css", new FileAttribute[0]).toAbsolutePath();
            File tempFile = temp.toFile();
            tempFile.deleteOnExit();
            Files.write(temp, css.getBytes(), new OpenOption[0]);
            String defaultEngineIconsCss = temp.toUri().toString();
            this.themeManager.setDefaultEngineIconsCss(defaultEngineIconsCss);
        }
        catch (IOException e) {
            this.LOGGER.warn("Could not set default engine icons.", (Throwable)e);
        }
    }
}

