/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.controller.containers;

import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableMap;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.containers.ContainersManager;
import org.phoenicis.engines.EngineSetting;
import org.phoenicis.engines.EngineSettingsManager;
import org.phoenicis.engines.EngineToolsManager;
import org.phoenicis.engines.EnginesManager;
import org.phoenicis.engines.VerbsManager;
import org.phoenicis.javafx.components.container.control.ContainersFeaturePanel;
import org.phoenicis.javafx.dialogs.ErrorDialog;
import org.phoenicis.repository.RepositoryManager;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.phoenicis.repository.dto.RepositoryDTO;

public class ContainersController {
    private final ContainersFeaturePanel containersView;
    private final EngineSettingsManager engineSettingsManager;
    private final EngineToolsManager engineToolsManager;
    private final VerbsManager verbsManager;

    public ContainersController(ContainersFeaturePanel containersView, ContainersManager containersManager, RepositoryManager repositoryManager, EngineSettingsManager engineSettingsManager, EnginesManager enginesManager, VerbsManager verbsManager, EngineToolsManager engineToolsManager) {
        this.containersView = containersView;
        this.engineSettingsManager = engineSettingsManager;
        this.verbsManager = verbsManager;
        this.engineToolsManager = engineToolsManager;
        this.containersView.setEnginesManager(enginesManager);
        this.containersView.setVerbsManager(verbsManager);
        this.containersView.setEngineToolsManager(engineToolsManager);
        this.containersView.setContainersManager(containersManager);
        repositoryManager.addCallbacks(this::updateEngineSettings, e -> Platform.runLater(() -> {
            ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Loading engine settings failed.")).withException((Exception)e).withOwner(this.containersView.getScene().getWindow()).build();
            errorDialog.showAndWait();
        }));
        repositoryManager.addCallbacks(this::updateVerbs, e -> Platform.runLater(() -> {
            ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Loading Verbs failed.")).withException((Exception)e).withOwner(this.containersView.getScene().getWindow()).build();
            errorDialog.showAndWait();
        }));
        repositoryManager.addCallbacks(this::updateEngineTools, e -> Platform.runLater(() -> {
            ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Loading engine tools failed.")).withException((Exception)e).withOwner(this.containersView.getScene().getWindow()).build();
            errorDialog.showAndWait();
        }));
    }

    public ContainersFeaturePanel getView() {
        return this.containersView;
    }

    private void updateEngineSettings(RepositoryDTO repositoryDTO) {
        this.engineSettingsManager.fetchAvailableEngineSettings(repositoryDTO, engineSettings -> Platform.runLater(() -> {
            ObservableMap<String, List<EngineSetting>> engineSettingsMap = this.containersView.getEngineSettings();
            engineSettingsMap.clear();
            engineSettingsMap.putAll(engineSettings);
        }), e -> Platform.runLater(() -> {
            ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Loading engine settings failed.")).withException((Exception)e).withOwner(this.containersView.getScene().getWindow()).build();
            errorDialog.showAndWait();
        }));
    }

    private void updateVerbs(RepositoryDTO repositoryDTO) {
        this.verbsManager.fetchAvailableVerbs(repositoryDTO, verbs -> Platform.runLater(() -> {
            ObservableMap<String, ApplicationDTO> verbsMap = this.containersView.getVerbs();
            verbsMap.clear();
            verbsMap.putAll(verbs);
        }));
    }

    private void updateEngineTools(RepositoryDTO repositoryDTO) {
        this.engineToolsManager.fetchAvailableEngineTools(repositoryDTO, engineTools -> Platform.runLater(() -> {
            ObservableMap<String, ApplicationDTO> engineToolsMap = this.containersView.getEngineTools();
            engineToolsMap.clear();
            engineToolsMap.putAll(engineTools);
        }));
    }
}

