/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.controller.apps;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.components.application.control.ApplicationsFeaturePanel;
import org.phoenicis.javafx.components.application.skin.ApplicationSidebarToggleGroupSkin;
import org.phoenicis.javafx.dialogs.ErrorDialog;
import org.phoenicis.javafx.themes.ThemeManager;
import org.phoenicis.repository.RepositoryManager;
import org.phoenicis.repository.dto.CategoryDTO;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.repository.dto.TypeDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppsController {
    private final Logger LOGGER = LoggerFactory.getLogger(AppsController.class);
    private final ApplicationsFeaturePanel view;
    private final ThemeManager themeManager;

    public AppsController(ApplicationsFeaturePanel view, RepositoryManager repositoryManager, ThemeManager themeManager) {
        this.view = view;
        this.themeManager = themeManager;
        repositoryManager.addCallbacks(this::populate, this::showError);
    }

    public ApplicationsFeaturePanel getView() {
        return this.view;
    }

    private void populate(RepositoryDTO repositoryDTO) {
        Platform.runLater(() -> {
            List categoryDTOS = ((TypeDTO)repositoryDTO.getTypes().get(0)).getCategories();
            this.setDefaultCategoryIcons(categoryDTOS);
            this.getView().getCategories().setAll((Collection)categoryDTOS);
            this.getView().setInitialized(true);
        });
    }

    private void showError(Exception e) {
        Platform.runLater(() -> {
            ErrorDialog errorDialog = ErrorDialog.builder().withOwner(this.view.getScene().getWindow()).withException(e).withMessage((String)Localisation.tr((Object)"Connecting to the repository failed.\nPlease check your connection and try again.")).build();
            errorDialog.showAndWait();
        });
    }

    private void setDefaultCategoryIcons(List<CategoryDTO> categories) {
        Platform.runLater(() -> {
            try {
                StringBuilder cssBuilder = new StringBuilder();
                for (CategoryDTO category : categories) {
                    cssBuilder.append("#" + ApplicationSidebarToggleGroupSkin.getToggleButtonId(category.getId()) + "{\n");
                    String categoryIconPath = Optional.ofNullable(category.getIcon()).map(categoryIcon -> categoryIcon.toString()).orElse("/org/phoenicis/javafx/views/common/phoenicis.png");
                    cssBuilder.append(String.format("-fx-background-image: url('%s');\n", categoryIconPath));
                    cssBuilder.append("}\n");
                }
                String css = cssBuilder.toString();
                Path temp = Files.createTempFile("defaultCategoryIcons", ".css", new FileAttribute[0]).toAbsolutePath();
                File tempFile = temp.toFile();
                tempFile.deleteOnExit();
                Files.write(temp, css.getBytes(), new OpenOption[0]);
                String defaultCategoryIconsCss = temp.toUri().toString();
                this.themeManager.setDefaultCategoryIconsCss(defaultCategoryIconsCss);
            }
            catch (IOException e) {
                this.LOGGER.warn("Could not set default category icons.", (Throwable)e);
            }
        });
    }
}

