/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.controller;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import org.phoenicis.javafx.components.installation.control.InstallationsFeaturePanel;
import org.phoenicis.javafx.controller.apps.AppsController;
import org.phoenicis.javafx.controller.containers.ContainersController;
import org.phoenicis.javafx.controller.engines.EnginesController;
import org.phoenicis.javafx.controller.library.LibraryController;
import org.phoenicis.javafx.controller.settings.SettingsController;
import org.phoenicis.javafx.settings.JavaFxSettingsManager;
import org.phoenicis.javafx.themes.ThemeManager;
import org.phoenicis.javafx.views.mainwindow.ui.MainWindow;
import org.phoenicis.repository.RepositoryManager;

public class MainController {
    private final MainWindow mainWindow;
    private final JavaFxSettingsManager javaFxSettingsManager;
    private String applicationName;

    public MainController(String applicationName, LibraryController libraryController, AppsController appsController, EnginesController enginesController, ContainersController containersController, InstallationsFeaturePanel installationsView, SettingsController settingsController, RepositoryManager repositoryManager, ThemeManager themeManager, JavaFxSettingsManager javaFxSettingsManager) {
        this.applicationName = applicationName;
        this.mainWindow = new MainWindow(applicationName, libraryController.getView(), appsController.getView(), enginesController.getView(), containersController.getView(), installationsView, settingsController.getView(), themeManager, javaFxSettingsManager);
        this.javaFxSettingsManager = javaFxSettingsManager;
        installationsView.setOnInstallationAdded(this.mainWindow::showInstallations);
        ChangeListener tabSelectedListener = (observable, oldValue, newValue) -> {
            if (newValue.booleanValue() && !repositoryManager.isRepositoryLoaded()) {
                repositoryManager.triggerRepositoryChange();
            }
        };
        this.mainWindow.getApplicationsTab().selectedProperty().addListener(tabSelectedListener);
        if (javaFxSettingsManager.isAdvancedMode()) {
            this.mainWindow.getContainersTab().selectedProperty().addListener(tabSelectedListener);
        }
    }

    public void show() {
        this.mainWindow.show();
    }

    public void setOnClose(Runnable onClose) {
        this.mainWindow.setOnCloseRequest(event -> {
            this.javaFxSettingsManager.setWindowHeight(this.mainWindow.getHeight());
            this.javaFxSettingsManager.setWindowWidth(this.mainWindow.getWidth());
            this.javaFxSettingsManager.setWindowMaximized(this.mainWindow.isMaximized());
            this.javaFxSettingsManager.save();
            Platform.exit();
            onClose.run();
        });
    }
}

