/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.controller;

import org.phoenicis.containers.ContainersConfiguration;
import org.phoenicis.engines.EnginesConfiguration;
import org.phoenicis.javafx.controller.MainController;
import org.phoenicis.javafx.controller.apps.AppsController;
import org.phoenicis.javafx.controller.containers.ContainersController;
import org.phoenicis.javafx.controller.engines.EnginesController;
import org.phoenicis.javafx.controller.library.LibraryController;
import org.phoenicis.javafx.controller.settings.SettingsController;
import org.phoenicis.javafx.settings.JavaFxSettingsConfiguration;
import org.phoenicis.javafx.themes.ThemeConfiguration;
import org.phoenicis.javafx.views.ViewsConfiguration;
import org.phoenicis.library.LibraryConfiguration;
import org.phoenicis.repository.RepositoryConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ControllerConfiguration {
    @Value(value="${application.name}")
    private String applicationName;
    @Autowired
    private ThemeConfiguration themeConfiguration;
    @Autowired
    private ViewsConfiguration viewsConfiguration;
    @Autowired
    private RepositoryConfiguration repositoryConfiguration;
    @Autowired
    private LibraryConfiguration libraryConfiguration;
    @Autowired
    private EnginesConfiguration enginesConfiguration;
    @Autowired
    private ContainersConfiguration containersConfiguration;
    @Autowired
    private JavaFxSettingsConfiguration javaFxSettingsConfiguration;

    @Bean
    public MainController mainController() {
        return new MainController(this.applicationName, this.libraryController(), this.appsController(), this.enginesController(), this.containersController(), this.viewsConfiguration.viewInstallations(), this.settingsController(), this.repositoryConfiguration.repositoryManager(), this.themeConfiguration.themeManager(), this.javaFxSettingsConfiguration.javaFxSettingsManager());
    }

    @Bean
    public ContainersController containersController() {
        return new ContainersController(this.viewsConfiguration.viewContainers(), this.containersConfiguration.backgroundContainersManager(), this.repositoryConfiguration.repositoryManager(), this.enginesConfiguration.engineSettingsManager(), this.enginesConfiguration.enginesSource(), this.enginesConfiguration.verbsManager(), this.enginesConfiguration.engineToolsManager());
    }

    @Bean
    public EnginesController enginesController() {
        return new EnginesController(this.viewsConfiguration.viewEngines(), this.repositoryConfiguration.repositoryManager(), this.enginesConfiguration.enginesSource(), this.themeConfiguration.themeManager());
    }

    @Bean
    public LibraryController libraryController() {
        return new LibraryController(this.viewsConfiguration.viewLibrary(), this.libraryConfiguration.libraryManager(), this.themeConfiguration.themeManager());
    }

    @Bean
    public AppsController appsController() {
        return new AppsController(this.viewsConfiguration.viewApps(), this.repositoryConfiguration.repositoryManager(), this.themeConfiguration.themeManager());
    }

    @Bean
    public SettingsController settingsController() {
        return new SettingsController(this.viewsConfiguration.viewSettings());
    }
}

