/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.setting.skin;

import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.setting.control.UserInterfacePanel;
import org.phoenicis.javafx.themes.Theme;

public class UserInterfacePanelSkin
extends SkinBase<UserInterfacePanel, UserInterfacePanelSkin> {
    public UserInterfacePanelSkin(UserInterfacePanel control) {
        super(control);
    }

    @Override
    public void initialise() {
        Text title = new Text((String)Localisation.tr((Object)"User Interface Settings"));
        title.getStyleClass().add((Object)"title");
        GridPane themeGrid = new GridPane();
        themeGrid.getStyleClass().add((Object)"grid");
        themeGrid.setHgap(20.0);
        themeGrid.setVgap(10.0);
        Text themeLabel = new Text((String)Localisation.tr((Object)"Theme"));
        themeLabel.getStyleClass().add((Object)"captionTitle");
        ComboBox<Theme> themeSelection = this.createThemeSelection();
        Label advancedModeLabel = new Label((String)Localisation.tr((Object)"Advanced mode (requires restart)"));
        advancedModeLabel.getStyleClass().add((Object)"captionTitle");
        CheckBox advancedModeSelection = new CheckBox();
        advancedModeSelection.selectedProperty().bindBidirectional((Property)((UserInterfacePanel)((Object)this.getControl())).advancedModeProperty());
        Label showScriptSourceLabel = new Label((String)Localisation.tr((Object)"View the scripts\u2019 source repository"));
        showScriptSourceLabel.getStyleClass().add((Object)"captionTitle");
        CheckBox showScriptSourceSelection = new CheckBox();
        showScriptSourceSelection.selectedProperty().bindBidirectional((Property)((UserInterfacePanel)((Object)this.getControl())).showScriptSourceProperty());
        Label scalingLabel = new Label((String)Localisation.tr((Object)"Scale the user interface"));
        scalingLabel.getStyleClass().add((Object)"captionTitle");
        Slider scalingSelection = new Slider();
        scalingSelection.setMin(8.0);
        scalingSelection.setMax(16.0);
        scalingSelection.valueProperty().bindBidirectional((Property)((UserInterfacePanel)((Object)this.getControl())).scalingProperty());
        Button restoreDefaultButton = new Button((String)Localisation.tr((Object)"Restore defaults (requires restart)"));
        restoreDefaultButton.setOnAction(event -> Optional.ofNullable(((UserInterfacePanel)((Object)((Object)this.getControl()))).getOnRestoreSettings()).ifPresent(Runnable::run));
        themeGrid.addRow(0, new Node[]{themeLabel, themeSelection});
        themeGrid.addRow(1, new Node[]{advancedModeLabel, advancedModeSelection});
        themeGrid.addRow(2, new Node[]{showScriptSourceLabel, showScriptSourceSelection});
        themeGrid.addRow(3, new Node[]{scalingLabel, scalingSelection});
        themeGrid.add((Node)restoreDefaultButton, 1, 4);
        VBox container = new VBox(new Node[]{title, themeGrid});
        container.getStyleClass().add((Object)"containerConfigurationPane");
        this.getChildren().setAll((Object[])new Node[]{container});
    }

    private ComboBox<Theme> createThemeSelection() {
        ComboBox themeSelection = new ComboBox();
        Bindings.bindContent((List)themeSelection.getItems(), ((UserInterfacePanel)((Object)this.getControl())).getThemes());
        themeSelection.valueProperty().bindBidirectional(((UserInterfacePanel)((Object)this.getControl())).selectedThemeProperty());
        themeSelection.setConverter((StringConverter)new StringConverter<Theme>(){

            public String toString(Theme theme) {
                return theme.getName();
            }

            public Theme fromString(String themeName) {
                Optional<Theme> foundTheme = ((UserInterfacePanel)((Object)UserInterfacePanelSkin.this.getControl())).getThemes().stream().filter(theme -> themeName.equals(theme.getName())).findFirst();
                return foundTheme.orElseThrow(() -> new IllegalArgumentException("Couldn't find theme with name \"" + themeName + "\""));
            }
        });
        return themeSelection;
    }
}

