/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.setting.skin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.setting.control.RepositoriesPanel;
import org.phoenicis.javafx.dialogs.SimpleConfirmDialog;
import org.phoenicis.javafx.views.mainwindow.settings.addrepository.AddRepositoryDialog;
import org.phoenicis.repository.location.RepositoryLocation;
import org.phoenicis.repository.types.Repository;

public class RepositoriesPanelSkin
extends SkinBase<RepositoriesPanel, RepositoriesPanelSkin> {
    private static final DataFormat repositoryLocationFormat = new DataFormat(new String[]{"application/x-java-serialized-object"});

    public RepositoriesPanelSkin(RepositoriesPanel control) {
        super(control);
    }

    @Override
    public void initialise() {
        Text title = new Text((String)Localisation.tr((Object)"Repository Settings"));
        title.getStyleClass().add((Object)"title");
        TableView<RepositoryLocation<? extends Repository>> repositoryLocationTable = this.createRepositoryLocationTable();
        VBox.setVgrow(repositoryLocationTable, (Priority)Priority.ALWAYS);
        HBox repositoryButtons = this.createRepositoryButtons(repositoryLocationTable);
        HBox refreshContainer = this.createRefreshButtonContainer();
        VBox container = new VBox(new Node[]{title, repositoryLocationTable, repositoryButtons, refreshContainer});
        container.getStyleClass().addAll((Object[])new String[]{"settings-tab", "repositories-panel"});
        this.getChildren().addAll((Object[])new Node[]{container});
    }

    private TableView<RepositoryLocation<? extends Repository>> createRepositoryLocationTable() {
        TableView repositoryLocationTable = new TableView();
        repositoryLocationTable.getStyleClass().add((Object)"repositories-table");
        repositoryLocationTable.getColumns().add(this.createColumn((String)Localisation.tr((Object)"Priority"), repositoryLocation -> ((RepositoriesPanel)((Object)((Object)this.getControl()))).getRepositoryLocations().indexOf(repositoryLocation) + 1));
        repositoryLocationTable.getColumns().add(this.createColumn((String)Localisation.tr((Object)"Repository name"), RepositoryLocation::toDisplayString));
        repositoryLocationTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.getStyleClass().add((Object)"repository-row");
            Tooltip repositoryLocationTooltip = new Tooltip((String)Localisation.tr((Object)"Move the repository up or down to change its priority"));
            row.emptyProperty().addListener(invalidation -> {
                if (row.isEmpty()) {
                    Tooltip.uninstall((Node)row, (Tooltip)repositoryLocationTooltip);
                } else {
                    Tooltip.install((Node)row, (Tooltip)repositoryLocationTooltip);
                }
            });
            row.setOnDragDetected(event -> {
                if (!row.isEmpty()) {
                    int index = row.getIndex();
                    Dragboard dragboard = row.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                    RepositoryLocation repositoryLocation = (RepositoryLocation)((RepositoriesPanel)((Object)((Object)((Object)this.getControl())))).getRepositoryLocations().get(index);
                    dragboard.setDragView(this.createPreviewImage((RepositoryLocation<? extends Repository>)repositoryLocation));
                    ClipboardContent content = new ClipboardContent();
                    content.put((Object)repositoryLocationFormat, (Object)index);
                    dragboard.setContent((Map)content);
                    event.consume();
                }
            });
            row.setOnDragOver(event -> {
                Dragboard dragboard = event.getDragboard();
                if (dragboard.hasContent(repositoryLocationFormat) && row.getIndex() != ((Integer)dragboard.getContent(repositoryLocationFormat)).intValue()) {
                    event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                    event.consume();
                }
            });
            row.setOnDragDropped(event -> {
                Dragboard dragboard = event.getDragboard();
                if (dragboard.hasContent(repositoryLocationFormat)) {
                    int draggedIndex = (Integer)dragboard.getContent(repositoryLocationFormat);
                    ArrayList<RepositoryLocation<? extends Repository>> workingCopy = new ArrayList<RepositoryLocation<? extends Repository>>((Collection<RepositoryLocation<? extends Repository>>)((RepositoriesPanel)((Object)((Object)((Object)this.getControl())))).getRepositoryLocations());
                    RepositoryLocation draggedRepositoryLocation = (RepositoryLocation)workingCopy.remove(draggedIndex);
                    int dropIndex = row.isEmpty() ? workingCopy.size() : row.getIndex();
                    workingCopy.add(dropIndex, (RepositoryLocation<? extends Repository>)draggedRepositoryLocation);
                    ((RepositoriesPanel)((Object)((Object)((Object)this.getControl())))).getRepositoryLocations().setAll(workingCopy);
                    event.setDropCompleted(true);
                    event.consume();
                }
            });
            return row;
        });
        Bindings.bindContent((List)repositoryLocationTable.getItems(), ((RepositoriesPanel)((Object)this.getControl())).getRepositoryLocations());
        return repositoryLocationTable;
    }

    private Image createPreviewImage(RepositoryLocation<? extends Repository> repositoryLocation) {
        Text text = new Text(repositoryLocation.toDisplayString());
        new Scene((Parent)new Group(new Node[]{text}));
        SnapshotParameters snapshotParameters = new SnapshotParameters();
        snapshotParameters.setFill((Paint)Color.TRANSPARENT);
        return text.snapshot(snapshotParameters, null);
    }

    private <E> TableColumn<RepositoryLocation<? extends Repository>, E> createColumn(String columnHeader, Function<RepositoryLocation<? extends Repository>, E> converter) {
        TableColumn column = new TableColumn(columnHeader);
        column.setCellValueFactory(cdf -> new SimpleObjectProperty(converter.apply((RepositoryLocation)cdf.getValue())));
        column.setSortable(false);
        column.setReorderable(false);
        return column;
    }

    private HBox createRepositoryButtons(TableView<RepositoryLocation<? extends Repository>> repositoryLocationTable) {
        Button addButton = new Button((String)Localisation.tr((Object)"Add"));
        addButton.getStyleClass().add((Object)"repositories-add");
        addButton.setOnAction(event -> {
            AddRepositoryDialog dialog = new AddRepositoryDialog();
            dialog.initOwner(((RepositoriesPanel)((Object)((Object)this.getControl()))).getScene().getWindow());
            Optional successResult = dialog.showAndWait();
            successResult.ifPresent(repositoryLocation -> ((RepositoriesPanel)((Object)((Object)((Object)this.getControl())))).getRepositoryLocations().add(0, repositoryLocation));
        });
        Button removeButton = new Button((String)Localisation.tr((Object)"Remove"));
        removeButton.getStyleClass().add((Object)"repositories-remove");
        removeButton.setOnAction(event -> {
            ObservableList toRemove = repositoryLocationTable.getSelectionModel().getSelectedItems();
            ((RepositoriesPanel)((Object)((Object)this.getControl()))).getRepositoryLocations().removeAll((Collection)toRemove);
        });
        Button restoreDefault = new Button((String)Localisation.tr((Object)"Restore defaults"));
        restoreDefault.getStyleClass().add((Object)"repositories-restore");
        restoreDefault.setOnAction(event -> {
            SimpleConfirmDialog dialog = SimpleConfirmDialog.builder().withTitle((String)Localisation.tr((Object)"Restore default repositories")).withMessage((String)Localisation.tr((Object)"Are you sure you want to restore the default repositories?")).withYesCallback(() -> Platform.runLater(() -> ((RepositoriesPanel)((Object)((Object)((Object)((Object)this.getControl()))))).getRepositoryLocations().setAll((Collection)((RepositoriesPanel)((Object)((Object)((Object)((Object)this.getControl()))))).getRepositoryLocationLoader().getDefaultRepositoryLocations()))).withOwner(((RepositoriesPanel)((Object)((Object)this.getControl()))).getScene().getWindow()).withResizable(true).build();
            dialog.showAndCallback();
        });
        HBox container = new HBox(new Node[]{addButton, removeButton, restoreDefault});
        container.getStyleClass().add((Object)"repositories-buttons-container");
        return container;
    }

    private HBox createRefreshButtonContainer() {
        Label refreshRepositoriesLabel = new Label((String)Localisation.tr((Object)"Fetch updates from the repositories to retrieve latest script versions"));
        refreshRepositoriesLabel.getStyleClass().add((Object)"repositories-refresh-label");
        HBox.setHgrow((Node)refreshRepositoriesLabel, (Priority)Priority.ALWAYS);
        Button refreshRepositoriesButton = new Button((String)Localisation.tr((Object)"Refresh Repositories"));
        refreshRepositoriesButton.setOnAction(event -> Optional.ofNullable(((RepositoriesPanel)((Object)((Object)this.getControl()))).getOnRepositoryRefresh()).ifPresent(Runnable::run));
        HBox container = new HBox(new Node[]{refreshRepositoriesLabel, refreshRepositoriesButton});
        container.getStyleClass().add((Object)"repositories-refresh-container");
        return container;
    }
}

