/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.setting.skin;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.setting.control.AboutPanel;
import org.phoenicis.javafx.components.setting.utils.ApplicationBuildInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutPanelSkin
extends SkinBase<AboutPanel, AboutPanelSkin> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AboutPanelSkin.class);

    public AboutPanelSkin(AboutPanel control) {
        super(control);
    }

    @Override
    public void initialise() {
        Text title = new Text((String)Localisation.tr((Object)"About"));
        title.getStyleClass().add((Object)"title");
        GridPane aboutGrid = this.createAboutGrid();
        VBox container = new VBox(new Node[]{title, aboutGrid});
        container.getStyleClass().add((Object)"containerConfigurationPane");
        this.getChildren().addAll((Object[])new Node[]{container});
    }

    private GridPane createAboutGrid() {
        GridPane aboutGrid = new GridPane();
        aboutGrid.getStyleClass().add((Object)"grid");
        aboutGrid.setHgap(20.0);
        aboutGrid.setVgap(10.0);
        Text nameDescription = new Text((String)Localisation.tr((Object)"Name:"));
        nameDescription.getStyleClass().add((Object)"captionTitle");
        Label nameLabel = new Label();
        nameLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> Optional.ofNullable(((AboutPanel)((Object)((Object)this.getControl()))).getBuildInformation()).map(ApplicationBuildInformation::getApplicationName).orElse(null), (Observable[])new Observable[]{((AboutPanel)((Object)this.getControl())).buildInformationProperty()}));
        aboutGrid.addRow(0, new Node[]{nameDescription, nameLabel});
        Text versionDescription = new Text((String)Localisation.tr((Object)"Version:"));
        versionDescription.getStyleClass().add((Object)"captionTitle");
        Label versionLabel = new Label();
        versionLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> Optional.ofNullable(((AboutPanel)((Object)((Object)this.getControl()))).getBuildInformation()).map(ApplicationBuildInformation::getApplicationVersion).orElse(null), (Observable[])new Observable[]{((AboutPanel)((Object)this.getControl())).buildInformationProperty()}));
        aboutGrid.addRow(1, new Node[]{versionDescription, versionLabel});
        Text gitRevisionDescription = new Text((String)Localisation.tr((Object)"Git Revision:"));
        gitRevisionDescription.getStyleClass().add((Object)"captionTitle");
        Hyperlink gitRevisionHyperlink = this.createGitRevisionHyperlink();
        aboutGrid.addRow(2, new Node[]{gitRevisionDescription, gitRevisionHyperlink});
        Text buildTimestampDescription = new Text((String)Localisation.tr((Object)"Build Timestamp:"));
        buildTimestampDescription.getStyleClass().add((Object)"captionTitle");
        Label buildTimestampLabel = new Label();
        buildTimestampLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> Optional.ofNullable(((AboutPanel)((Object)((Object)this.getControl()))).getBuildInformation()).map(ApplicationBuildInformation::getApplicationBuildTimestamp).orElse(null), (Observable[])new Observable[]{((AboutPanel)((Object)this.getControl())).buildInformationProperty()}));
        aboutGrid.addRow(3, new Node[]{buildTimestampDescription, buildTimestampLabel});
        return aboutGrid;
    }

    private Hyperlink createGitRevisionHyperlink() {
        StringBinding revisionText = Bindings.createStringBinding(() -> Optional.ofNullable(((AboutPanel)((Object)((Object)this.getControl()))).getBuildInformation()).map(ApplicationBuildInformation::getApplicationGitRevision).orElse(null), (Observable[])new Observable[]{((AboutPanel)((Object)this.getControl())).buildInformationProperty()});
        BooleanBinding disableProperty = Bindings.when((ObservableBooleanValue)Bindings.and((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)revisionText), (ObservableBooleanValue)Bindings.notEqual((ObservableStringValue)revisionText, (String)"unknown"))).then(false).otherwise(true);
        Hyperlink gitRevisionHyperlink = new Hyperlink();
        gitRevisionHyperlink.textProperty().bind((ObservableValue)revisionText);
        gitRevisionHyperlink.disableProperty().bind((ObservableValue)disableProperty);
        gitRevisionHyperlink.visitedProperty().bind((ObservableValue)disableProperty);
        gitRevisionHyperlink.underlineProperty().bind((ObservableValue)disableProperty);
        gitRevisionHyperlink.setOnAction(event -> {
            try {
                URI uri = new URI("https://github.com/PhoenicisOrg/phoenicis/commit/" + ((AboutPanel)((Object)((Object)this.getControl()))).getBuildInformation().getApplicationGitRevision());
                ((AboutPanel)((Object)((Object)this.getControl()))).getOpener().open(uri);
            }
            catch (URISyntaxException e) {
                LOGGER.error("Could not open GitHub URL.", (Throwable)e);
            }
        });
        return gitRevisionHyperlink;
    }
}

