/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.library.skin;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.apache.commons.lang.StringUtils;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.components.common.control.KeyAttributeList;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.library.control.ShortcutInformationPanel;
import org.phoenicis.javafx.utils.CollectionBindings;
import org.phoenicis.javafx.utils.StringBindings;
import org.phoenicis.javafx.views.common.ColumnConstraintsWithPercentage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortcutInformationPanelSkin
extends SkinBase<ShortcutInformationPanel, ShortcutInformationPanelSkin> {
    private final Logger LOGGER = LoggerFactory.getLogger(ShortcutInformationPanelSkin.class);
    private final StringBinding description = StringBindings.map(((ShortcutInformationPanel)((Object)this.getControl())).shortcutProperty(), shortcut -> shortcut.getInfo().getDescription());
    private final ObservableMap<String, Object> shortcutProperties = CollectionBindings.mapToMap(((ShortcutInformationPanel)((Object)this.getControl())).shortcutProperty(), shortcut -> {
        try {
            return (Map)((ShortcutInformationPanel)((Object)((Object)this.getControl()))).getObjectMapper().readValue(shortcut.getScript(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            this.LOGGER.error("An error occurred during a shortcut update", (Throwable)e);
            return Map.of();
        }
    });
    private final ObservableMap<String, String> environmentAttributes = FXCollections.observableHashMap();

    public ShortcutInformationPanelSkin(ShortcutInformationPanel control) {
        super(control);
    }

    @Override
    public void initialise() {
        GridPane controlButtons = this.createControlButtons();
        if (((ShortcutInformationPanel)((Object)this.getControl())).getJavaFxSettingsManager().isAdvancedMode()) {
            Label descriptionLabel = new Label();
            descriptionLabel.textProperty().bind((ObservableValue)this.description);
            descriptionLabel.setWrapText(true);
            GridPane propertiesGrid = this.createPropertiesGrid();
            Label environmentLabel = new Label((String)Localisation.tr((Object)"Environment"));
            environmentLabel.getStyleClass().add((Object)"sectionTitle");
            environmentLabel.setWrapText(true);
            KeyAttributeList environmentAttributeList = this.createKeyAttributeList();
            Region spacer = new Region();
            spacer.getStyleClass().add((Object)"detailsButtonSpacer");
            VBox container = new VBox(new Node[]{descriptionLabel, propertiesGrid, environmentLabel, environmentAttributeList, spacer, controlButtons});
            this.getChildren().setAll((Object[])new Node[]{container});
        } else {
            VBox container = new VBox(new Node[]{controlButtons});
            this.getChildren().setAll((Object[])new Node[]{container});
        }
    }

    private GridPane createPropertiesGrid() {
        GridPane propertiesGrid = new GridPane();
        propertiesGrid.getStyleClass().add((Object)"grid");
        ColumnConstraintsWithPercentage titleColumn = new ColumnConstraintsWithPercentage(30.0);
        ColumnConstraintsWithPercentage valueColumn = new ColumnConstraintsWithPercentage(70.0);
        propertiesGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{titleColumn, valueColumn});
        this.shortcutProperties.addListener(invalidation -> this.updateProperties(propertiesGrid));
        this.updateProperties(propertiesGrid);
        return propertiesGrid;
    }

    private KeyAttributeList createKeyAttributeList() {
        KeyAttributeList keyAttributeList = new KeyAttributeList();
        this.environmentAttributes.addListener(invalidated -> keyAttributeList.setAttributeMap((Map<String, String>)this.environmentAttributes));
        keyAttributeList.setAttributeMap((Map<String, String>)this.environmentAttributes);
        return keyAttributeList;
    }

    private GridPane createControlButtons() {
        GridPane controlButtons = new GridPane();
        controlButtons.getStyleClass().add((Object)"shortcut-control-button-group");
        Button runButton = new Button((String)Localisation.tr((Object)"Run"));
        runButton.getStyleClass().addAll((Object[])new String[]{"shortcutButton", "runButton"});
        runButton.setOnMouseClicked(event -> Optional.ofNullable(((ShortcutInformationPanel)((Object)((Object)this.getControl()))).getOnShortcutRun()).ifPresent(onShortcutRun -> onShortcutRun.accept(((ShortcutInformationPanel)((Object)((Object)((Object)this.getControl())))).getShortcut())));
        GridPane.setHalignment((Node)runButton, (HPos)HPos.CENTER);
        Button stopButton = new Button((String)Localisation.tr((Object)"Close"));
        stopButton.getStyleClass().addAll((Object[])new String[]{"shortcutButton", "stopButton"});
        stopButton.setOnMouseClicked(event -> Optional.ofNullable(((ShortcutInformationPanel)((Object)((Object)this.getControl()))).getOnShortcutStop()).ifPresent(onShortcutStop -> onShortcutStop.accept(((ShortcutInformationPanel)((Object)((Object)((Object)this.getControl())))).getShortcut())));
        GridPane.setHalignment((Node)stopButton, (HPos)HPos.CENTER);
        Button uninstallButton = new Button((String)Localisation.tr((Object)"Uninstall"));
        uninstallButton.getStyleClass().addAll((Object[])new String[]{"shortcutButton", "uninstallButton"});
        uninstallButton.setOnMouseClicked(event -> Optional.ofNullable(((ShortcutInformationPanel)((Object)((Object)this.getControl()))).getOnShortcutUninstall()).ifPresent(onShortcutUninstall -> onShortcutUninstall.accept(((ShortcutInformationPanel)((Object)((Object)((Object)this.getControl())))).getShortcut())));
        GridPane.setHalignment((Node)uninstallButton, (HPos)HPos.CENTER);
        if (((ShortcutInformationPanel)((Object)this.getControl())).getJavaFxSettingsManager().isAdvancedMode()) {
            Button editButton = new Button((String)Localisation.tr((Object)"Edit"));
            editButton.getStyleClass().addAll((Object[])new String[]{"shortcutButton", "editButton"});
            editButton.setOnMouseClicked(event -> Optional.ofNullable(((ShortcutInformationPanel)((Object)((Object)this.getControl()))).getOnShortcutEdit()).ifPresent(onShortcutEdit -> onShortcutEdit.accept(((ShortcutInformationPanel)((Object)((Object)((Object)this.getControl())))).getShortcut())));
            GridPane.setHalignment((Node)editButton, (HPos)HPos.CENTER);
            ColumnConstraintsWithPercentage runColumn = new ColumnConstraintsWithPercentage(25.0);
            ColumnConstraintsWithPercentage stopColumn = new ColumnConstraintsWithPercentage(25.0);
            ColumnConstraintsWithPercentage uninstallColumn = new ColumnConstraintsWithPercentage(25.0);
            ColumnConstraintsWithPercentage editColumn = new ColumnConstraintsWithPercentage(25.0);
            controlButtons.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{runColumn, stopColumn, uninstallColumn, editColumn});
            controlButtons.addRow(0, new Node[]{runButton, stopButton, uninstallButton, editButton});
        } else {
            ColumnConstraintsWithPercentage runColumn = new ColumnConstraintsWithPercentage(33.0);
            ColumnConstraintsWithPercentage stopColumn = new ColumnConstraintsWithPercentage(33.0);
            ColumnConstraintsWithPercentage uninstallColumn = new ColumnConstraintsWithPercentage(33.0);
            controlButtons.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{runColumn, stopColumn, uninstallColumn});
            controlButtons.addRow(0, new Node[]{runButton, stopButton, uninstallButton});
        }
        return controlButtons;
    }

    private void updateProperties(GridPane propertiesGrid) {
        propertiesGrid.getChildren().clear();
        for (Map.Entry entry : this.shortcutProperties.entrySet()) {
            int row = propertiesGrid.getRowCount();
            if (((String)entry.getKey()).equals("environment")) continue;
            Label keyLabel = new Label((String)Localisation.tr((Object)this.decamelize((String)entry.getKey())) + ":");
            keyLabel.getStyleClass().add((Object)"captionTitle");
            GridPane.setValignment((Node)keyLabel, (VPos)VPos.TOP);
            Label valueLabel = new Label(entry.getValue().toString());
            valueLabel.setWrapText(true);
            propertiesGrid.addRow(row, new Node[]{keyLabel, valueLabel});
        }
        this.environmentAttributes.clear();
        if (this.shortcutProperties.containsKey((Object)"environment")) {
            Map environment = (Map)this.shortcutProperties.get((Object)"environment");
            this.environmentAttributes.putAll(environment);
        }
    }

    private String decamelize(String string) {
        return StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)string), (char)' '));
    }
}

