/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.library.skin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import org.apache.commons.lang.StringUtils;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.components.common.control.KeyAttributeList;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.library.control.ShortcutEditingPanel;
import org.phoenicis.javafx.utils.CollectionBindings;
import org.phoenicis.javafx.utils.StringBindings;
import org.phoenicis.javafx.views.common.ColumnConstraintsWithPercentage;
import org.phoenicis.library.dto.ShortcutDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortcutEditingPanelSkin
extends SkinBase<ShortcutEditingPanel, ShortcutEditingPanelSkin> {
    private final Logger LOGGER = LoggerFactory.getLogger(ShortcutEditingPanelSkin.class);
    private final StringBinding description = StringBindings.map(((ShortcutEditingPanel)((Object)this.getControl())).shortcutProperty(), shortcut -> shortcut.getInfo().getDescription());
    private final ObservableMap<String, Object> shortcutProperties = CollectionBindings.mapToMap(((ShortcutEditingPanel)((Object)this.getControl())).shortcutProperty(), shortcut -> {
        try {
            return (Map)((ShortcutEditingPanel)((Object)((Object)this.getControl()))).getObjectMapper().readValue(shortcut.getScript(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            this.LOGGER.error("An error occurred during a shortcut update", (Throwable)e);
            return Map.of();
        }
    });
    private final ObservableMap<String, String> environmentAttributes = FXCollections.observableHashMap();

    public ShortcutEditingPanelSkin(ShortcutEditingPanel control) {
        super(control);
    }

    @Override
    public void initialise() {
        Label descriptionLabel = new Label();
        descriptionLabel.textProperty().bind((ObservableValue)this.description);
        descriptionLabel.setWrapText(true);
        GridPane propertiesGrid = this.createPropertiesGrid();
        Label environmentLabel = new Label((String)Localisation.tr((Object)"Environment"));
        environmentLabel.getStyleClass().add((Object)"sectionTitle");
        environmentLabel.setWrapText(true);
        KeyAttributeList environmentAttributeList = this.createKeyAttributeList();
        Region spacer = new Region();
        spacer.getStyleClass().add((Object)"detailsButtonSpacer");
        Button saveButton = new Button((String)Localisation.tr((Object)"Save"));
        saveButton.setOnMouseClicked(event -> Optional.ofNullable(((ShortcutEditingPanel)((Object)((Object)this.getControl()))).getOnShortcutChanged()).ifPresent(onShortcutChanged -> onShortcutChanged.accept(((ShortcutEditingPanel)((Object)((Object)((Object)this.getControl())))).getShortcut())));
        VBox container = new VBox(new Node[]{descriptionLabel, propertiesGrid, environmentLabel, environmentAttributeList, spacer, saveButton});
        this.getChildren().setAll((Object[])new Node[]{container});
    }

    private GridPane createPropertiesGrid() {
        GridPane propertiesGrid = new GridPane();
        propertiesGrid.getStyleClass().add((Object)"grid");
        ColumnConstraintsWithPercentage titleColumn = new ColumnConstraintsWithPercentage(30.0);
        ColumnConstraintsWithPercentage valueColumn = new ColumnConstraintsWithPercentage(70.0);
        propertiesGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{titleColumn, valueColumn});
        this.shortcutProperties.addListener(invalidation -> this.updateProperties(propertiesGrid));
        this.updateProperties(propertiesGrid);
        return propertiesGrid;
    }

    private KeyAttributeList createKeyAttributeList() {
        KeyAttributeList keyAttributeList = new KeyAttributeList();
        keyAttributeList.setEditable(true);
        keyAttributeList.setOnChange(environment -> {
            this.shortcutProperties.replace((Object)"environment", environment);
            try {
                ShortcutDTO shortcut = ((ShortcutEditingPanel)((Object)((Object)this.getControl()))).getShortcut();
                String json = new ObjectMapper().writeValueAsString(this.shortcutProperties);
                ((ShortcutEditingPanel)((Object)((Object)this.getControl()))).setShortcut(new ShortcutDTO.Builder(shortcut).withScript(json).build());
            }
            catch (JsonProcessingException e) {
                this.LOGGER.error("Creating new shortcut String failed.", (Throwable)e);
            }
        });
        this.environmentAttributes.addListener(invalidated -> keyAttributeList.setAttributeMap((Map<String, String>)this.environmentAttributes));
        keyAttributeList.setAttributeMap((Map<String, String>)this.environmentAttributes);
        return keyAttributeList;
    }

    private void updateProperties(GridPane propertiesGrid) {
        propertiesGrid.getChildren().clear();
        Label miniatureLabel = new Label((String)Localisation.tr((Object)"Miniature:"));
        miniatureLabel.getStyleClass().add((Object)"captionTitle");
        GridPane.setValignment((Node)miniatureLabel, (VPos)VPos.TOP);
        TextField miniaturePathField = new TextField(Optional.ofNullable(((ShortcutEditingPanel)((Object)this.getControl())).getShortcut()).map(ShortcutDTO::getMiniature).map(URI::getPath).orElse(""));
        HBox.setHgrow((Node)miniaturePathField, (Priority)Priority.ALWAYS);
        Button openBrowser = new Button((String)Localisation.tr((Object)"Browse..."));
        openBrowser.setOnAction(event -> {
            URI miniatureURI = Optional.ofNullable(((ShortcutEditingPanel)((Object)((Object)this.getControl()))).getShortcut()).map(ShortcutDTO::getMiniature).orElseThrow(() -> new IllegalStateException("The shortcut is null"));
            FileChooser chooser = new FileChooser();
            chooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter((String)Localisation.tr((Object)"Images"), new String[]{"*.miniature, *.png"}));
            File defaultFile = new File(miniatureURI);
            chooser.setInitialDirectory(defaultFile.getParentFile());
            Optional.ofNullable(chooser.showOpenDialog(((ShortcutEditingPanel)((Object)((Object)this.getControl()))).getScene().getWindow())).ifPresent(newMiniature -> {
                miniaturePathField.setText(newMiniature.toString());
                ((ShortcutEditingPanel)((Object)((Object)((Object)this.getControl())))).setShortcut(new ShortcutDTO.Builder(((ShortcutEditingPanel)((Object)((Object)((Object)this.getControl())))).getShortcut()).withMiniature(newMiniature.toURI()).build());
            });
        });
        HBox miniatureContainer = new HBox(new Node[]{miniaturePathField, openBrowser});
        propertiesGrid.addRow(0, new Node[]{miniatureLabel, miniatureContainer});
        for (Map.Entry entry : this.shortcutProperties.entrySet()) {
            int row = propertiesGrid.getRowCount();
            if ("environment".equals(entry.getKey())) continue;
            Label keyLabel = new Label((String)Localisation.tr((Object)this.decamelize((String)entry.getKey())) + ":");
            keyLabel.getStyleClass().add((Object)"captionTitle");
            GridPane.setValignment((Node)keyLabel, (VPos)VPos.TOP);
            TextArea valueLabel = new TextArea(entry.getValue().toString());
            valueLabel.setWrapText(true);
            valueLabel.setPrefRowCount(entry.getValue().toString().length() / 25);
            valueLabel.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.shortcutProperties.replace((Object)((String)entry.getKey()), (Object)valueLabel.getText());
                    try {
                        ShortcutDTO shortcut = ((ShortcutEditingPanel)((Object)((Object)this.getControl()))).getShortcut();
                        String json = new ObjectMapper().writeValueAsString(this.shortcutProperties);
                        ((ShortcutEditingPanel)((Object)((Object)this.getControl()))).setShortcut(new ShortcutDTO.Builder(shortcut).withScript(json).build());
                    }
                    catch (JsonProcessingException e) {
                        this.LOGGER.error("Creating new shortcut String failed.", (Throwable)e);
                    }
                }
            });
            propertiesGrid.addRow(row, new Node[]{keyLabel, valueLabel});
        }
        this.environmentAttributes.clear();
        if (this.shortcutProperties.containsKey((Object)"environment")) {
            Map environment = (Map)this.shortcutProperties.get((Object)"environment");
            this.environmentAttributes.putAll(environment);
        }
    }

    private String decamelize(String string) {
        return StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)string), (char)' '));
    }
}

