/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.library.skin;

import java.io.File;
import java.net.URI;
import javafx.css.PseudoClass;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import org.apache.commons.lang.StringUtils;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.library.control.ShortcutCreationPanel;
import org.phoenicis.javafx.views.common.ColumnConstraintsWithPercentage;
import org.phoenicis.library.dto.ShortcutCreationDTO;

public class ShortcutCreationPanelSkin
extends SkinBase<ShortcutCreationPanel, ShortcutCreationPanelSkin> {
    private final PseudoClass errorClass = PseudoClass.getPseudoClass((String)"error");

    public ShortcutCreationPanelSkin(ShortcutCreationPanel control) {
        super(control);
    }

    @Override
    public void initialise() {
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add((Object)"shortcut-information-grid");
        ColumnConstraintsWithPercentage labelConstraints = new ColumnConstraintsWithPercentage(30.0);
        ColumnConstraintsWithPercentage valueConstraints = new ColumnConstraintsWithPercentage(70.0);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{labelConstraints, valueConstraints});
        TextField name = this.addName(gridPane);
        Tooltip nameErrorTooltip = new Tooltip((String)Localisation.tr((Object)"Please specify a name!"));
        TextField category = this.addCategory(gridPane);
        Tooltip categoryErrorTooltip = new Tooltip((String)Localisation.tr((Object)"Please specify a category!"));
        TextArea description = this.addDescription(gridPane);
        TextField miniature = this.addMiniature(gridPane);
        Tooltip miniatureErrorTooltip = new Tooltip((String)Localisation.tr((Object)"Please specify a valid miniature!"));
        TextField executable = this.addExecutable(gridPane);
        Tooltip executableErrorTooltip = new Tooltip((String)Localisation.tr((Object)"Please specify a valid executable!"));
        Button createButton = new Button((String)Localisation.tr((Object)"Create"));
        createButton.setOnMouseClicked(event -> {
            File executableFile;
            boolean error = false;
            if (StringUtils.isEmpty((String)name.getText())) {
                name.pseudoClassStateChanged(this.errorClass, true);
                name.setTooltip(nameErrorTooltip);
                error = true;
            }
            if (StringUtils.isEmpty((String)category.getText())) {
                category.pseudoClassStateChanged(this.errorClass, true);
                category.setTooltip(categoryErrorTooltip);
                error = true;
            }
            URI miniatureUri = null;
            if (StringUtils.isNotEmpty((String)miniature.getText())) {
                File miniatureFile = new File(miniature.getText());
                if (miniatureFile.exists()) {
                    miniatureUri = miniatureFile.toURI();
                } else {
                    miniature.pseudoClassStateChanged(this.errorClass, true);
                    miniature.setTooltip(miniatureErrorTooltip);
                    error = true;
                }
            }
            if (!(executableFile = new File(executable.getText())).exists()) {
                executable.pseudoClassStateChanged(this.errorClass, true);
                executable.setTooltip(executableErrorTooltip);
                error = true;
            }
            if (!error) {
                ShortcutCreationDTO newShortcut = new ShortcutCreationDTO.Builder().withName(name.getText()).withCategory(category.getText()).withDescription(description.getText()).withMiniature(miniatureUri).withExecutable(executableFile).build();
                ((ShortcutCreationPanel)((Object)((Object)this.getControl()))).getOnCreateShortcut().accept(newShortcut);
            }
        });
        VBox container = new VBox(new Node[]{gridPane, createButton});
        container.getStyleClass().addAll((Object[])new String[]{"library-details-panel-content", "create-shortcut-panel-content"});
        this.getChildren().setAll((Object[])new Node[]{container});
    }

    private TextField addName(GridPane gridPane) {
        int row = gridPane.getRowCount();
        Label nameLabel = new Label((String)Localisation.tr((Object)"Name:"));
        nameLabel.getStyleClass().add((Object)"captionTitle");
        GridPane.setValignment((Node)nameLabel, (VPos)VPos.TOP);
        TextField name = new TextField();
        gridPane.addRow(row, new Node[]{nameLabel, name});
        return name;
    }

    private TextField addCategory(GridPane gridPane) {
        int row = gridPane.getRowCount();
        Label categoryLabel = new Label((String)Localisation.tr((Object)"Category:"));
        categoryLabel.getStyleClass().add((Object)"captionTitle");
        GridPane.setValignment((Node)categoryLabel, (VPos)VPos.TOP);
        TextField category = new TextField();
        gridPane.addRow(row, new Node[]{categoryLabel, category});
        return category;
    }

    private TextArea addDescription(GridPane gridPane) {
        int row = gridPane.getRowCount();
        Label descriptionLabel = new Label((String)Localisation.tr((Object)"Description:"));
        descriptionLabel.getStyleClass().add((Object)"captionTitle");
        GridPane.setValignment((Node)descriptionLabel, (VPos)VPos.TOP);
        TextArea description = new TextArea();
        gridPane.addRow(row, new Node[]{descriptionLabel, description});
        return description;
    }

    private TextField addMiniature(GridPane gridPane) {
        int row = gridPane.getRowCount();
        Label miniatureLabel = new Label((String)Localisation.tr((Object)"Miniature:"));
        miniatureLabel.getStyleClass().add((Object)"captionTitle");
        GridPane.setValignment((Node)miniatureLabel, (VPos)VPos.TOP);
        TextField miniature = new TextField();
        Button openMiniatureBrowser = new Button((String)Localisation.tr((Object)"Browse..."));
        openMiniatureBrowser.setOnAction(event -> {
            FileChooser chooser = new FileChooser();
            File containersDir = new File(((ShortcutCreationPanel)((Object)((Object)this.getControl()))).getContainersPath());
            if (containersDir.canRead()) {
                chooser.setInitialDirectory(containersDir);
            }
            chooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter((String)Localisation.tr((Object)"Images"), new String[]{"*.miniature, *.png"}));
            File newMiniature = chooser.showOpenDialog(((ShortcutCreationPanel)((Object)((Object)this.getControl()))).getScene().getWindow());
            if (newMiniature != null) {
                miniature.setText(newMiniature.toString());
            }
        });
        HBox miniatureHbox = new HBox(new Node[]{miniature, openMiniatureBrowser});
        miniatureHbox.getStyleClass().add((Object)"file-selection-container");
        HBox.setHgrow((Node)miniature, (Priority)Priority.ALWAYS);
        gridPane.addRow(row, new Node[]{miniatureLabel, miniatureHbox});
        return miniature;
    }

    private TextField addExecutable(GridPane gridPane) {
        int row = gridPane.getRowCount();
        Label executableLabel = new Label((String)Localisation.tr((Object)"Executable:"));
        executableLabel.getStyleClass().add((Object)"captionTitle");
        GridPane.setValignment((Node)executableLabel, (VPos)VPos.TOP);
        TextField executable = new TextField();
        Button openExecutableBrowser = new Button((String)Localisation.tr((Object)"Browse..."));
        openExecutableBrowser.setOnAction(event -> {
            File newExecutable;
            FileChooser chooser = new FileChooser();
            File containersDir = new File(((ShortcutCreationPanel)((Object)((Object)this.getControl()))).getContainersPath());
            if (containersDir.canRead()) {
                chooser.setInitialDirectory(containersDir);
            }
            if ((newExecutable = chooser.showOpenDialog(((ShortcutCreationPanel)((Object)((Object)this.getControl()))).getScene().getWindow())) != null) {
                executable.setText(newExecutable.toString());
            }
        });
        HBox executableHbox = new HBox(new Node[]{executable, openExecutableBrowser});
        executableHbox.getStyleClass().add((Object)"file-selection-container");
        HBox.setHgrow((Node)executable, (Priority)Priority.ALWAYS);
        gridPane.addRow(row, new Node[]{executableLabel, executableHbox});
        return executable;
    }
}

