/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.library.skin;

import java.io.File;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.stage.FileChooser;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.components.common.control.SidebarGroup;
import org.phoenicis.javafx.components.common.skin.ExtendedSidebarSkinBase;
import org.phoenicis.javafx.components.library.control.LibrarySidebar;
import org.phoenicis.javafx.components.library.control.LibrarySidebarToggleGroup;
import org.phoenicis.library.dto.ShortcutCategoryDTO;

public class LibrarySidebarSkin
extends ExtendedSidebarSkinBase<ShortcutCategoryDTO, LibrarySidebar, LibrarySidebarSkin> {
    public LibrarySidebarSkin(LibrarySidebar control) {
        super(control);
    }

    @Override
    protected ScrollPane createMainContent() {
        if (((LibrarySidebar)((Object)this.getControl())).getJavaFxSettingsManager().isAdvancedMode()) {
            return LibrarySidebarSkin.createScrollPane(new Node[]{this.createSidebarToggleGroup(), LibrarySidebarSkin.createSpacer(), this.createAdvancedToolsGroup()});
        }
        return LibrarySidebarSkin.createScrollPane(new Node[]{this.createSidebarToggleGroup()});
    }

    private LibrarySidebarToggleGroup createSidebarToggleGroup() {
        FilteredList filteredShortcutCategories = ((LibrarySidebar)((Object)this.getControl())).getItems().filtered(((LibrarySidebar)((Object)this.getControl())).getFilter()::filter);
        filteredShortcutCategories.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((LibrarySidebar)((Object)((Object)this.getControl()))).getFilter()::filter, (Observable[])new Observable[]{((LibrarySidebar)((Object)this.getControl())).searchTermProperty()}));
        LibrarySidebarToggleGroup categoryView = new LibrarySidebarToggleGroup((String)Localisation.tr((Object)"Categories"), (ObservableList<ShortcutCategoryDTO>)filteredShortcutCategories);
        ((LibrarySidebar)((Object)this.getControl())).selectedShortcutCategoryProperty().bind(categoryView.selectedElementProperty());
        return categoryView;
    }

    private SidebarGroup<Button> createAdvancedToolsGroup() {
        Button createShortcut = new Button((String)Localisation.tr((Object)"Create shortcut"));
        createShortcut.getStyleClass().addAll((Object[])new String[]{"sidebarButton", "openTerminal"});
        createShortcut.setOnMouseClicked(event -> Optional.ofNullable(((LibrarySidebar)((Object)((Object)this.getControl()))).getOnCreateShortcut()).ifPresent(Runnable::run));
        Button runScript = new Button((String)Localisation.tr((Object)"Run a script"));
        runScript.getStyleClass().addAll((Object[])new String[]{"sidebarButton", "scriptButton"});
        runScript.setOnMouseClicked(event -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle((String)Localisation.tr((Object)"Open Script..."));
            File scriptToRun = fileChooser.showOpenDialog(((LibrarySidebar)((Object)((Object)this.getControl()))).getScene().getWindow());
            if (scriptToRun != null) {
                Optional.ofNullable(((LibrarySidebar)((Object)((Object)this.getControl()))).getOnScriptRun()).ifPresent(onScriptRun -> onScriptRun.accept(scriptToRun));
            }
        });
        Button runConsole = new Button(Localisation.tr((String)"{0} console", (Object)((LibrarySidebar)((Object)this.getControl())).getApplicationName()));
        runConsole.getStyleClass().addAll((Object[])new String[]{"sidebarButton", "consoleButton"});
        runConsole.setOnMouseClicked(event -> Optional.ofNullable(((LibrarySidebar)((Object)((Object)this.getControl()))).getOnOpenConsole()).ifPresent(Runnable::run));
        SidebarGroup<Button> advancedToolsGroup = new SidebarGroup<Button>((String)Localisation.tr((Object)"Advanced Tools"));
        advancedToolsGroup.getComponents().addAll((Object[])new Button[]{createShortcut, runConsole});
        return advancedToolsGroup;
    }
}

