/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.library.skin;

import java.util.Comparator;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.MouseEvent;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.collections.ConcatenatedList;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.components.common.control.DetailsPanel;
import org.phoenicis.javafx.components.common.control.SidebarBase;
import org.phoenicis.javafx.components.common.panelstates.None;
import org.phoenicis.javafx.components.common.skin.FeaturePanelSkin;
import org.phoenicis.javafx.components.common.widgets.control.CombinedListWidget;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetElement;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetType;
import org.phoenicis.javafx.components.library.control.LibraryFeaturePanel;
import org.phoenicis.javafx.components.library.control.LibrarySidebar;
import org.phoenicis.javafx.components.library.control.ShortcutCreationPanel;
import org.phoenicis.javafx.components.library.control.ShortcutEditingPanel;
import org.phoenicis.javafx.components.library.control.ShortcutInformationPanel;
import org.phoenicis.javafx.components.library.panelstates.ShortcutCreation;
import org.phoenicis.javafx.components.library.panelstates.ShortcutEditing;
import org.phoenicis.javafx.components.library.panelstates.ShortcutInformation;
import org.phoenicis.javafx.settings.JavaFxSettingsManager;
import org.phoenicis.javafx.utils.ObjectBindings;
import org.phoenicis.javafx.utils.StringBindings;
import org.phoenicis.javafx.utils.SwitchBinding;
import org.phoenicis.library.ShortcutManager;
import org.phoenicis.library.dto.ShortcutCategoryDTO;
import org.phoenicis.library.dto.ShortcutDTO;

public class LibraryFeaturePanelSkin
extends FeaturePanelSkin<LibraryFeaturePanel, LibraryFeaturePanelSkin> {
    private final ObjectProperty<ListWidgetType> selectedListWidget = new SimpleObjectProperty();

    public LibraryFeaturePanelSkin(LibraryFeaturePanel control) {
        super(control);
    }

    @Override
    public ObjectExpression<SidebarBase<?, ?, ?>> createSidebar() {
        SortedList sortedCategories = ((LibraryFeaturePanel)((Object)this.getControl())).getCategories().sorted(Comparator.comparing(ShortcutCategoryDTO::getName));
        LibrarySidebar sidebar = new LibrarySidebar(((LibraryFeaturePanel)((Object)this.getControl())).getFilter(), (ObservableList<ShortcutCategoryDTO>)sortedCategories, this.selectedListWidget);
        sidebar.applicationNameProperty().bind((ObservableValue)((LibraryFeaturePanel)((Object)this.getControl())).applicationNameProperty());
        sidebar.javaFxSettingsManagerProperty().bind(((LibraryFeaturePanel)((Object)this.getControl())).javaFxSettingsManagerProperty());
        sidebar.setOnCreateShortcut(() -> {
            ((LibraryFeaturePanel)((Object)((Object)this.getControl()))).setSelectedShortcut(null);
            ((LibraryFeaturePanel)((Object)((Object)this.getControl()))).setOpenedDetailsPanel(new ShortcutCreation());
        });
        sidebar.setOnOpenConsole(((LibraryFeaturePanel)((Object)this.getControl()))::openConsole);
        sidebar.setSelectedListWidget(Optional.ofNullable(((LibraryFeaturePanel)((Object)this.getControl())).getJavaFxSettingsManager()).map(JavaFxSettingsManager::getLibraryListType).orElse(ListWidgetType.ICONS_LIST));
        sidebar.selectedListWidgetProperty().addListener((observable, oldValue, newValue) -> {
            JavaFxSettingsManager javaFxSettingsManager = ((LibraryFeaturePanel)((Object)((Object)this.getControl()))).getJavaFxSettingsManager();
            if (newValue != null) {
                javaFxSettingsManager.setLibraryListType((ListWidgetType)((Object)newValue));
                javaFxSettingsManager.save();
            }
        });
        return new SimpleObjectProperty((Object)sidebar);
    }

    @Override
    public ObjectExpression<Node> createContent() {
        CombinedListWidget<ShortcutDTO> combinedListWidget = this.createCombinedListWidget();
        Tab installedApplicationsTab = new Tab((String)Localisation.tr((Object)"My applications"), combinedListWidget);
        installedApplicationsTab.setClosable(false);
        TabPane container = new TabPane();
        container.getStyleClass().add((Object)"rightPane");
        ((LibraryFeaturePanel)((Object)this.getControl())).selectedTabProperty().addListener(invalidation -> {
            Tab selectedTab = ((LibraryFeaturePanel)((Object)((Object)this.getControl()))).getSelectedTab();
            if (selectedTab != null) {
                container.getSelectionModel().select((Object)selectedTab);
            } else {
                container.getSelectionModel().selectFirst();
            }
        });
        container.getSelectionModel().selectedItemProperty().addListener(invalidation -> ((LibraryFeaturePanel)((Object)((Object)this.getControl()))).setSelectedTab((Tab)container.getSelectionModel().getSelectedItem()));
        Bindings.bindContentBidirectional((ObservableList)container.getTabs(), ((LibraryFeaturePanel)((Object)this.getControl())).getTabs());
        container.getTabs().add((Object)installedApplicationsTab);
        return new SimpleObjectProperty((Object)container);
    }

    private CombinedListWidget<ShortcutDTO> createCombinedListWidget() {
        FilteredList filteredShortcuts = ConcatenatedList.create((ObservableList)new MappedList((ObservableList)((LibraryFeaturePanel)((Object)this.getControl())).getCategories().sorted(Comparator.comparing(ShortcutCategoryDTO::getName)), ShortcutCategoryDTO::getShortcuts)).filtered(((LibraryFeaturePanel)((Object)this.getControl())).getFilter()::filter);
        filteredShortcuts.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((LibraryFeaturePanel)((Object)((Object)this.getControl()))).getFilter()::filter, (Observable[])new Observable[]{((LibraryFeaturePanel)((Object)this.getControl())).getFilter().searchTermProperty(), ((LibraryFeaturePanel)((Object)this.getControl())).getFilter().selectedShortcutCategoryProperty()}));
        SortedList sortedShortcuts = filteredShortcuts.sorted(Comparator.comparing(shortcut -> shortcut.getInfo().getName()));
        MappedList listWidgetEntries = new MappedList((ObservableList)sortedShortcuts, ListWidgetElement::create);
        CombinedListWidget<ShortcutDTO> combinedListWidget = new CombinedListWidget<ShortcutDTO>((ObservableList<ListWidgetElement<ShortcutDTO>>)listWidgetEntries, this.selectedListWidget);
        ((LibraryFeaturePanel)((Object)this.getControl())).selectedShortcutProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                combinedListWidget.select((ShortcutDTO)newValue);
            } else {
                combinedListWidget.deselect();
            }
        });
        combinedListWidget.selectedElementProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                ShortcutDTO selectedItem = (ShortcutDTO)newValue.getItem();
                MouseEvent event = newValue.getEvent();
                ((LibraryFeaturePanel)((Object)((Object)this.getControl()))).setSelectedShortcut(selectedItem);
                ((LibraryFeaturePanel)((Object)((Object)this.getControl()))).setOpenedDetailsPanel(new ShortcutInformation(selectedItem));
                if (event.getClickCount() == 2) {
                    ((LibraryFeaturePanel)((Object)((Object)this.getControl()))).runShortcut(selectedItem);
                }
            } else {
                ((LibraryFeaturePanel)((Object)((Object)this.getControl()))).setSelectedShortcut(null);
                ((LibraryFeaturePanel)((Object)((Object)this.getControl()))).setOpenedDetailsPanel(new None());
            }
        });
        return combinedListWidget;
    }

    @Override
    public ObjectExpression<DetailsPanel> createDetailsPanel() {
        return SwitchBinding.builder(((LibraryFeaturePanel)((Object)this.getControl())).openedDetailsPanelProperty()).withCase(ShortcutInformation.class, this::createShortcutInformationDetailsPanel).withCase(ShortcutCreation.class, action -> this.createShortcutCreationDetailsPanel()).withCase(ShortcutEditing.class, this::createShortcutEditingDetailsPanel).withCase(None.class, action -> null).build();
    }

    private DetailsPanel createShortcutCreationDetailsPanel() {
        ShortcutCreationPanel shortcutCreationPanel = new ShortcutCreationPanel();
        shortcutCreationPanel.setOnCreateShortcut(((LibraryFeaturePanel)((Object)this.getControl()))::createShortcut);
        shortcutCreationPanel.containersPathProperty().bind((ObservableValue)((LibraryFeaturePanel)((Object)this.getControl())).containersPathProperty());
        DetailsPanel detailsPanel = new DetailsPanel();
        detailsPanel.setTitle((String)Localisation.tr((Object)"Create a new shortcut"));
        detailsPanel.setContent((Node)shortcutCreationPanel);
        detailsPanel.setOnClose(((LibraryFeaturePanel)((Object)this.getControl()))::closeDetailsPanel);
        detailsPanel.prefWidthProperty().bind((ObservableValue)((LibraryFeaturePanel)((Object)this.getControl())).widthProperty().divide(3));
        return detailsPanel;
    }

    private DetailsPanel createShortcutEditingDetailsPanel(ShortcutEditing action) {
        ShortcutEditingPanel shortcutEditingPanel = new ShortcutEditingPanel();
        shortcutEditingPanel.onShortcutChangedProperty().bind(ObjectBindings.map(((LibraryFeaturePanel)((Object)this.getControl())).shortcutManagerProperty(), shortcutManager -> arg_0 -> ((ShortcutManager)shortcutManager).updateShortcut(arg_0)));
        shortcutEditingPanel.objectMapperProperty().bind(((LibraryFeaturePanel)((Object)this.getControl())).objectMapperProperty());
        shortcutEditingPanel.setShortcut(action.getShortcut());
        DetailsPanel detailsPanel = new DetailsPanel();
        detailsPanel.titleProperty().bind((ObservableValue)StringBindings.map(((LibraryFeaturePanel)((Object)this.getControl())).selectedShortcutProperty(), shortcut -> shortcut.getInfo().getName()));
        detailsPanel.setContent((Node)shortcutEditingPanel);
        detailsPanel.setOnClose(((LibraryFeaturePanel)((Object)this.getControl()))::closeDetailsPanel);
        detailsPanel.prefWidthProperty().bind((ObservableValue)((LibraryFeaturePanel)((Object)this.getControl())).widthProperty().divide(3));
        return detailsPanel;
    }

    private DetailsPanel createShortcutInformationDetailsPanel(ShortcutInformation action) {
        ShortcutInformationPanel shortcutInformationPanel = new ShortcutInformationPanel();
        shortcutInformationPanel.javaFxSettingsManagerProperty().bind(((LibraryFeaturePanel)((Object)this.getControl())).javaFxSettingsManagerProperty());
        shortcutInformationPanel.setShortcut(action.getShortcut());
        shortcutInformationPanel.objectMapperProperty().bind(((LibraryFeaturePanel)((Object)this.getControl())).objectMapperProperty());
        shortcutInformationPanel.setOnShortcutRun(((LibraryFeaturePanel)((Object)this.getControl()))::runShortcut);
        shortcutInformationPanel.setOnShortcutStop(((LibraryFeaturePanel)((Object)this.getControl()))::stopShortcut);
        shortcutInformationPanel.setOnShortcutUninstall(((LibraryFeaturePanel)((Object)this.getControl()))::uninstallShortcut);
        shortcutInformationPanel.setOnShortcutEdit(shortcut -> ((LibraryFeaturePanel)((Object)((Object)this.getControl()))).setOpenedDetailsPanel(new ShortcutEditing(((LibraryFeaturePanel)((Object)((Object)this.getControl()))).getSelectedShortcut())));
        DetailsPanel detailsPanel = new DetailsPanel();
        detailsPanel.titleProperty().bind((ObservableValue)StringBindings.map(((LibraryFeaturePanel)((Object)this.getControl())).selectedShortcutProperty(), shortcut -> shortcut.getInfo().getName()));
        detailsPanel.setContent((Node)shortcutInformationPanel);
        detailsPanel.setOnClose(((LibraryFeaturePanel)((Object)this.getControl()))::closeDetailsPanel);
        detailsPanel.prefWidthProperty().bind((ObservableValue)((LibraryFeaturePanel)((Object)this.getControl())).widthProperty().divide(3));
        return detailsPanel;
    }
}

