/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.library.control;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Tab;
import org.apache.commons.lang.StringUtils;
import org.graalvm.polyglot.Value;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.components.common.control.FeaturePanel;
import org.phoenicis.javafx.components.common.panelstates.None;
import org.phoenicis.javafx.components.common.panelstates.OpenDetailsPanel;
import org.phoenicis.javafx.components.library.skin.LibraryFeaturePanelSkin;
import org.phoenicis.javafx.controller.library.console.ConsoleController;
import org.phoenicis.javafx.dialogs.ErrorDialog;
import org.phoenicis.javafx.dialogs.SimpleConfirmDialog;
import org.phoenicis.javafx.settings.JavaFxSettingsManager;
import org.phoenicis.javafx.views.mainwindow.console.ConsoleTab;
import org.phoenicis.javafx.views.mainwindow.library.LibraryFilter;
import org.phoenicis.library.ShortcutManager;
import org.phoenicis.library.ShortcutRunner;
import org.phoenicis.library.dto.ShortcutCategoryDTO;
import org.phoenicis.library.dto.ShortcutCreationDTO;
import org.phoenicis.library.dto.ShortcutDTO;
import org.phoenicis.scripts.interpreter.ScriptInterpreter;
import org.phoenicis.scripts.session.InteractiveScriptSession;

public class LibraryFeaturePanel
extends FeaturePanel<LibraryFeaturePanel, LibraryFeaturePanelSkin> {
    private final StringProperty applicationName = new SimpleStringProperty();
    private final StringProperty containersPath = new SimpleStringProperty();
    private final ObjectProperty<LibraryFilter> filter = new SimpleObjectProperty();
    private final ObjectProperty<JavaFxSettingsManager> javaFxSettingsManager = new SimpleObjectProperty();
    private final ObjectProperty<ScriptInterpreter> scriptInterpreter = new SimpleObjectProperty();
    private final ObjectProperty<ObjectMapper> objectMapper = new SimpleObjectProperty();
    private final ObservableList<ShortcutCategoryDTO> categories = FXCollections.observableArrayList();
    private final ObservableList<Tab> tabs = FXCollections.observableArrayList();
    private final ObjectProperty<Tab> selectedTab;
    private final ObjectProperty<ConsoleController> consoleController = new SimpleObjectProperty();
    private final ObjectProperty<ShortcutRunner> shortcutRunner = new SimpleObjectProperty();
    private final ObjectProperty<ShortcutManager> shortcutManager = new SimpleObjectProperty();
    private final ObjectProperty<ShortcutDTO> selectedShortcut;
    private final ObjectProperty<OpenDetailsPanel> openedDetailsPanel;

    public LibraryFeaturePanel() {
        this.selectedTab = new SimpleObjectProperty();
        this.selectedShortcut = new SimpleObjectProperty();
        this.openedDetailsPanel = new SimpleObjectProperty((Object)new None());
    }

    @Override
    public LibraryFeaturePanelSkin createSkin() {
        return new LibraryFeaturePanelSkin(this);
    }

    public void createShortcut(ShortcutCreationDTO shortcutCreationDTO) {
        String executablePath = shortcutCreationDTO.getExecutable().getAbsolutePath();
        String pathInContainers = executablePath.replace(this.getContainersPath(), "");
        String[] split = pathInContainers.split("/");
        String engineContainer = split[0];
        String engine = StringUtils.capitalize((String)engineContainer).replace("prefix", "");
        String engineId = engine.toLowerCase();
        String container = split[1];
        InteractiveScriptSession interactiveScriptSession = this.getScriptInterpreter().createInteractiveSession();
        String scriptInclude = "const Shortcut = include(\"engines." + engineId + ".shortcuts." + engineId + "\");";
        interactiveScriptSession.eval(scriptInclude, ignored -> interactiveScriptSession.eval("new Shortcut()", output -> {
            Value shortcutObject = (Value)output;
            shortcutObject.invokeMember("name", new Object[]{shortcutCreationDTO.getName()});
            shortcutObject.invokeMember("category", new Object[]{shortcutCreationDTO.getCategory()});
            shortcutObject.invokeMember("description", new Object[]{shortcutCreationDTO.getDescription()});
            shortcutObject.invokeMember("miniature", new Object[]{shortcutCreationDTO.getMiniature()});
            shortcutObject.invokeMember("search", new Object[]{shortcutCreationDTO.getExecutable().getName()});
            shortcutObject.invokeMember("prefix", new Object[]{container});
            shortcutObject.invokeMember("create", new Object[0]);
        }, e -> Platform.runLater(() -> {
            ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error while creating shortcut")).withException((Exception)e).withOwner(this.getScene().getWindow()).build();
            errorDialog.showAndWait();
        })), e -> Platform.runLater(() -> {
            ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error while creating shortcut")).withException((Exception)e).withOwner(this.getScene().getWindow()).build();
            errorDialog.showAndWait();
        }));
    }

    public void runShortcut(ShortcutDTO shortcut) {
        this.getShortcutRunner().run(shortcut, Collections.emptyList(), e -> Platform.runLater(() -> {
            ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error")).withException((Exception)e).withOwner(this.getScene().getWindow()).build();
            errorDialog.showAndWait();
        }));
    }

    public void stopShortcut(ShortcutDTO shortcut) {
        this.getShortcutRunner().stop(shortcut, e -> Platform.runLater(() -> {
            ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error")).withException((Exception)e).withOwner(this.getScene().getWindow()).build();
            errorDialog.showAndWait();
        }));
    }

    public void uninstallShortcut(ShortcutDTO shortcut) {
        String shortcutName = shortcut.getInfo().getName();
        SimpleConfirmDialog confirmMessage = SimpleConfirmDialog.builder().withTitle(Localisation.tr((String)"Uninstall {0}", (Object)shortcutName)).withMessage(Localisation.tr((String)"Are you sure you want to uninstall {0}?", (Object)shortcutName)).withOwner(this.getScene().getWindow()).withResizable(true).withYesCallback(() -> this.getShortcutManager().uninstallFromShortcut(shortcut, e -> {
            ErrorDialog errorDialog = ErrorDialog.builder().withMessage(Localisation.tr((String)"Error while uninstalling {0}", (Object)shortcutName)).withException((Exception)e).withOwner(this.getScene().getWindow()).build();
            errorDialog.showAndWait();
        })).build();
        confirmMessage.showAndCallback();
    }

    public void openConsole() {
        ConsoleTab console = this.getConsoleController().createConsole();
        this.getTabs().add((Object)console);
        this.setSelectedTab(console);
    }

    public String getApplicationName() {
        return (String)this.applicationName.get();
    }

    public StringProperty applicationNameProperty() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName.set((Object)applicationName);
    }

    public String getContainersPath() {
        return (String)this.containersPath.get();
    }

    public StringProperty containersPathProperty() {
        return this.containersPath;
    }

    public void setContainersPath(String containersPath) {
        this.containersPath.set((Object)containersPath);
    }

    public LibraryFilter getFilter() {
        return (LibraryFilter)this.filter.get();
    }

    public ObjectProperty<LibraryFilter> filterProperty() {
        return this.filter;
    }

    public void setFilter(LibraryFilter filter) {
        this.filter.set((Object)filter);
    }

    public JavaFxSettingsManager getJavaFxSettingsManager() {
        return (JavaFxSettingsManager)this.javaFxSettingsManager.get();
    }

    public ObjectProperty<JavaFxSettingsManager> javaFxSettingsManagerProperty() {
        return this.javaFxSettingsManager;
    }

    public void setJavaFxSettingsManager(JavaFxSettingsManager javaFxSettingsManager) {
        this.javaFxSettingsManager.set((Object)javaFxSettingsManager);
    }

    public ScriptInterpreter getScriptInterpreter() {
        return (ScriptInterpreter)this.scriptInterpreter.get();
    }

    public ObjectProperty<ScriptInterpreter> scriptInterpreterProperty() {
        return this.scriptInterpreter;
    }

    public void setScriptInterpreter(ScriptInterpreter scriptInterpreter) {
        this.scriptInterpreter.set((Object)scriptInterpreter);
    }

    public ObjectMapper getObjectMapper() {
        return (ObjectMapper)this.objectMapper.get();
    }

    public ObjectProperty<ObjectMapper> objectMapperProperty() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper.set((Object)objectMapper);
    }

    public ObservableList<ShortcutCategoryDTO> getCategories() {
        return this.categories;
    }

    public ObservableList<Tab> getTabs() {
        return this.tabs;
    }

    public Tab getSelectedTab() {
        return (Tab)this.selectedTab.get();
    }

    public ObjectProperty<Tab> selectedTabProperty() {
        return this.selectedTab;
    }

    public void setSelectedTab(Tab selectedTab) {
        this.selectedTab.set((Object)selectedTab);
    }

    public ConsoleController getConsoleController() {
        return (ConsoleController)this.consoleController.get();
    }

    public ObjectProperty<ConsoleController> consoleControllerProperty() {
        return this.consoleController;
    }

    public void setConsoleController(ConsoleController consoleController) {
        this.consoleController.set((Object)consoleController);
    }

    public ShortcutRunner getShortcutRunner() {
        return (ShortcutRunner)this.shortcutRunner.get();
    }

    public ObjectProperty<ShortcutRunner> shortcutRunnerProperty() {
        return this.shortcutRunner;
    }

    public void setShortcutRunner(ShortcutRunner shortcutRunner) {
        this.shortcutRunner.set((Object)shortcutRunner);
    }

    public ShortcutManager getShortcutManager() {
        return (ShortcutManager)this.shortcutManager.get();
    }

    public ObjectProperty<ShortcutManager> shortcutManagerProperty() {
        return this.shortcutManager;
    }

    public void setShortcutManager(ShortcutManager shortcutManager) {
        this.shortcutManager.set((Object)shortcutManager);
    }

    public ShortcutDTO getSelectedShortcut() {
        return (ShortcutDTO)this.selectedShortcut.get();
    }

    public ObjectProperty<ShortcutDTO> selectedShortcutProperty() {
        return this.selectedShortcut;
    }

    public void setSelectedShortcut(ShortcutDTO selectedShortcut) {
        this.selectedShortcut.set((Object)selectedShortcut);
    }

    public OpenDetailsPanel getOpenedDetailsPanel() {
        return (OpenDetailsPanel)this.openedDetailsPanel.get();
    }

    public ObjectProperty<OpenDetailsPanel> openedDetailsPanelProperty() {
        return this.openedDetailsPanel;
    }

    public void setOpenedDetailsPanel(OpenDetailsPanel openDetailsPanel) {
        this.openedDetailsPanel.set((Object)openDetailsPanel);
    }

    @Override
    public void closeDetailsPanel() {
        this.setSelectedShortcut(null);
        this.setOpenedDetailsPanel(new None());
    }
}

