/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.installation.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.views.mainwindow.installations.dto.InstallationCategoryDTO;
import org.phoenicis.javafx.views.mainwindow.installations.dto.InstallationDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstallationsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstallationsUtils.class);

    private InstallationsUtils() {
    }

    public static List<InstallationCategoryDTO> addInstallationToList(List<InstallationCategoryDTO> list, InstallationDTO toAdd) {
        String newInstallationCategory = toAdd.getCategory().toString();
        InstallationCategoryDTO newCategory = new InstallationCategoryDTO.Builder().withId(newInstallationCategory).withName((String)Localisation.tr((Object)newInstallationCategory)).withInstallations(Collections.singletonList(toAdd)).build();
        TreeMap<String, InstallationCategoryDTO> mergedCategories = new TreeMap<String, InstallationCategoryDTO>(InstallationsUtils.createSortedMap(list, InstallationCategoryDTO::getId));
        if (mergedCategories.containsKey(newCategory.getId())) {
            InstallationCategoryDTO tempMergedCategory = (InstallationCategoryDTO)mergedCategories.get(newCategory.getId());
            mergedCategories.put(newCategory.getId(), InstallationsUtils.mergeCategories(tempMergedCategory, newCategory));
        } else {
            mergedCategories.put(newCategory.getId(), newCategory);
        }
        return mergedCategories.values().stream().sorted(InstallationCategoryDTO.nameComparator()).collect(Collectors.toList());
    }

    public static List<InstallationCategoryDTO> removeInstallationFromList(List<InstallationCategoryDTO> list, InstallationDTO toRemove) {
        String newInstallationCategory = toRemove.getCategory().toString();
        TreeMap<String, InstallationCategoryDTO> newCategories = new TreeMap<String, InstallationCategoryDTO>(InstallationsUtils.createSortedMap(list, InstallationCategoryDTO::getId));
        if (newCategories.containsKey(newInstallationCategory)) {
            InstallationCategoryDTO mergedCategory = InstallationsUtils.removeFromCategory((InstallationCategoryDTO)newCategories.get(newInstallationCategory), toRemove);
            if (mergedCategory.getInstallations().isEmpty()) {
                newCategories.remove(mergedCategory.getId());
            } else {
                newCategories.replace(mergedCategory.getId(), mergedCategory);
            }
        }
        return newCategories.values().stream().sorted(InstallationCategoryDTO.nameComparator()).collect(Collectors.toList());
    }

    private static InstallationCategoryDTO mergeCategories(InstallationCategoryDTO leftCategory, InstallationCategoryDTO rightCategory) {
        Map<String, InstallationDTO> leftInstallations = InstallationsUtils.createSortedMap(leftCategory.getInstallations(), InstallationDTO::getId);
        Map<String, InstallationDTO> rightInstallations = InstallationsUtils.createSortedMap(rightCategory.getInstallations(), InstallationDTO::getId);
        TreeMap<String, InstallationDTO> mergedInstallations = new TreeMap<String, InstallationDTO>(rightInstallations);
        for (Map.Entry<String, InstallationDTO> entry : leftInstallations.entrySet()) {
            InstallationDTO application = entry.getValue();
            if (mergedInstallations.containsKey(entry.getKey())) {
                LOGGER.error(String.format("Installation %s exists already!", entry.getKey()));
                continue;
            }
            mergedInstallations.put(entry.getKey(), application);
        }
        List<InstallationDTO> installations = mergedInstallations.values().stream().sorted(InstallationDTO.nameComparator()).collect(Collectors.toList());
        return new InstallationCategoryDTO.Builder().withId(leftCategory.getId()).withName(leftCategory.getName()).withInstallations(installations).withIcon(leftCategory.getIcon()).build();
    }

    private static InstallationCategoryDTO removeFromCategory(InstallationCategoryDTO category, InstallationDTO newInstallation) {
        TreeMap<String, InstallationDTO> mergedInstallations = new TreeMap<String, InstallationDTO>(InstallationsUtils.createSortedMap(category.getInstallations(), InstallationDTO::getId));
        if (mergedInstallations.containsKey(newInstallation.getId())) {
            mergedInstallations.remove(newInstallation.getId());
        }
        List<InstallationDTO> installations = mergedInstallations.values().stream().sorted(InstallationDTO.nameComparator()).collect(Collectors.toList());
        return new InstallationCategoryDTO.Builder().withId(category.getId()).withName(category.getName()).withInstallations(installations).withIcon(category.getIcon()).build();
    }

    private static <T> Map<String, T> createSortedMap(List<T> dtos, Function<T, String> nameProvider) {
        TreeMap map = new TreeMap();
        dtos.forEach(dto -> map.put((String)nameProvider.apply(dto), dto));
        return map;
    }
}

