/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.installation.skin;

import java.util.Comparator;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.Node;
import org.phoenicis.javafx.collections.ConcatenatedList;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.components.common.control.DetailsPanel;
import org.phoenicis.javafx.components.common.control.SidebarBase;
import org.phoenicis.javafx.components.common.panelstates.None;
import org.phoenicis.javafx.components.common.skin.FeaturePanelSkin;
import org.phoenicis.javafx.components.common.widgets.control.CombinedListWidget;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetElement;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetType;
import org.phoenicis.javafx.components.installation.control.InstallationSidebar;
import org.phoenicis.javafx.components.installation.control.InstallationsFeaturePanel;
import org.phoenicis.javafx.components.installation.panelstates.Installation;
import org.phoenicis.javafx.settings.JavaFxSettingsManager;
import org.phoenicis.javafx.utils.SwitchBinding;
import org.phoenicis.javafx.views.mainwindow.installations.dto.InstallationCategoryDTO;
import org.phoenicis.javafx.views.mainwindow.installations.dto.InstallationDTO;

public class InstallationsFeaturePanelSkin
extends FeaturePanelSkin<InstallationsFeaturePanel, InstallationsFeaturePanelSkin> {
    private final ObjectProperty<ListWidgetType> selectedListWidget = new SimpleObjectProperty();

    public InstallationsFeaturePanelSkin(InstallationsFeaturePanel control) {
        super(control);
    }

    @Override
    public ObjectExpression<SidebarBase<?, ?, ?>> createSidebar() {
        SortedList sortedCategories = ((InstallationsFeaturePanel)((Object)this.getControl())).getInstallationCategories().sorted(Comparator.comparing(InstallationCategoryDTO::getName));
        InstallationSidebar sidebar = new InstallationSidebar(((InstallationsFeaturePanel)((Object)this.getControl())).getFilter(), (ObservableList<InstallationCategoryDTO>)sortedCategories, this.selectedListWidget);
        sidebar.setSelectedListWidget(Optional.ofNullable(((InstallationsFeaturePanel)((Object)this.getControl())).getJavaFxSettingsManager()).map(JavaFxSettingsManager::getInstallationsListType).orElse(ListWidgetType.ICONS_LIST));
        sidebar.selectedListWidgetProperty().addListener((observable, oldValue, newValue) -> {
            JavaFxSettingsManager javaFxSettingsManager = ((InstallationsFeaturePanel)((Object)((Object)this.getControl()))).getJavaFxSettingsManager();
            if (newValue != null) {
                javaFxSettingsManager.setInstallationsListType((ListWidgetType)((Object)newValue));
                javaFxSettingsManager.save();
            }
        });
        return new SimpleObjectProperty((Object)sidebar);
    }

    @Override
    public ObjectExpression<Node> createContent() {
        FilteredList filteredInstallations = ConcatenatedList.create((ObservableList)new MappedList((ObservableList)((InstallationsFeaturePanel)((Object)this.getControl())).getInstallationCategories().sorted(Comparator.comparing(InstallationCategoryDTO::getName)), InstallationCategoryDTO::getInstallations)).filtered(((InstallationsFeaturePanel)((Object)this.getControl())).getFilter()::filter);
        filteredInstallations.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((InstallationsFeaturePanel)((Object)((Object)this.getControl()))).getFilter()::filter, (Observable[])new Observable[]{((InstallationsFeaturePanel)((Object)this.getControl())).getFilter().searchTermProperty(), ((InstallationsFeaturePanel)((Object)this.getControl())).getFilter().selectedInstallationCategoryProperty()}));
        SortedList sortedInstallations = filteredInstallations.sorted(Comparator.comparing(InstallationDTO::getName));
        MappedList listWidgetEntries = new MappedList((ObservableList)sortedInstallations, ListWidgetElement::create);
        CombinedListWidget combinedListWidget = new CombinedListWidget(listWidgetEntries, this.selectedListWidget);
        ((InstallationsFeaturePanel)((Object)this.getControl())).selectedInstallationProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                combinedListWidget.select(newValue);
            } else {
                combinedListWidget.deselect();
            }
        });
        combinedListWidget.selectedElementProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                InstallationDTO selectedItem = (InstallationDTO)newValue.getItem();
                ((InstallationsFeaturePanel)((Object)((Object)this.getControl()))).setSelectedInstallation(selectedItem);
                ((InstallationsFeaturePanel)((Object)((Object)this.getControl()))).setOpenedDetailsPanel(new Installation(selectedItem));
            } else {
                ((InstallationsFeaturePanel)((Object)((Object)this.getControl()))).setSelectedInstallation(null);
                ((InstallationsFeaturePanel)((Object)((Object)this.getControl()))).setOpenedDetailsPanel(new None());
            }
        });
        return new SimpleObjectProperty(combinedListWidget);
    }

    @Override
    public ObjectExpression<DetailsPanel> createDetailsPanel() {
        return SwitchBinding.builder(((InstallationsFeaturePanel)((Object)this.getControl())).openedDetailsPanelProperty()).withCase(Installation.class, this::createInstallationDetailsPanel).withCase(None.class, action -> null).build();
    }

    private DetailsPanel createInstallationDetailsPanel(Installation action) {
        InstallationDTO installation = action.getInstallation();
        DetailsPanel detailsPanel = new DetailsPanel();
        detailsPanel.setTitle(installation.getName());
        detailsPanel.setContent(installation.getNode());
        detailsPanel.setOnClose(((InstallationsFeaturePanel)((Object)this.getControl()))::closeDetailsPanel);
        detailsPanel.prefWidthProperty().bind((ObservableValue)((InstallationsFeaturePanel)((Object)this.getControl())).widthProperty().divide(3));
        return detailsPanel;
    }
}

