/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.installation.control;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.phoenicis.javafx.components.common.control.FeaturePanel;
import org.phoenicis.javafx.components.common.panelstates.None;
import org.phoenicis.javafx.components.common.panelstates.OpenDetailsPanel;
import org.phoenicis.javafx.components.installation.skin.InstallationsFeaturePanelSkin;
import org.phoenicis.javafx.components.installation.utils.InstallationsUtils;
import org.phoenicis.javafx.settings.JavaFxSettingsManager;
import org.phoenicis.javafx.views.mainwindow.installations.InstallationsFilter;
import org.phoenicis.javafx.views.mainwindow.installations.dto.InstallationCategoryDTO;
import org.phoenicis.javafx.views.mainwindow.installations.dto.InstallationDTO;

public class InstallationsFeaturePanel
extends FeaturePanel<InstallationsFeaturePanel, InstallationsFeaturePanelSkin> {
    private final ObjectProperty<InstallationsFilter> filter = new SimpleObjectProperty();
    private final ObjectProperty<JavaFxSettingsManager> javaFxSettingsManager = new SimpleObjectProperty();
    private final ObservableList<InstallationCategoryDTO> installationCategories = FXCollections.observableArrayList();
    private final ObjectProperty<Runnable> onInstallationAdded = new SimpleObjectProperty();
    private final ObjectProperty<InstallationDTO> selectedInstallation = new SimpleObjectProperty();
    private final ObjectProperty<OpenDetailsPanel> openedDetailsPanel = new SimpleObjectProperty((Object)new None());

    @Override
    public InstallationsFeaturePanelSkin createSkin() {
        return new InstallationsFeaturePanelSkin(this);
    }

    public void addInstallation(InstallationDTO installationDTO) {
        List<InstallationCategoryDTO> installationCategories = InstallationsUtils.addInstallationToList(this.getInstallationCategories(), installationDTO);
        Platform.runLater(() -> {
            this.getInstallationCategories().setAll((Collection)installationCategories);
            this.setSelectedInstallation(installationDTO);
        });
        Optional.ofNullable(this.getOnInstallationAdded()).ifPresent(Runnable::run);
    }

    public void removeInstallation(InstallationDTO installationDTO) {
        List<InstallationCategoryDTO> installationCategories = InstallationsUtils.removeInstallationFromList(this.getInstallationCategories(), installationDTO);
        Platform.runLater(() -> {
            this.getInstallationCategories().setAll((Collection)installationCategories);
            if (this.getSelectedInstallation().equals(installationDTO)) {
                this.setSelectedInstallation(null);
            }
        });
    }

    public InstallationsFilter getFilter() {
        return (InstallationsFilter)this.filter.get();
    }

    public ObjectProperty<InstallationsFilter> filterProperty() {
        return this.filter;
    }

    public void setFilter(InstallationsFilter filter) {
        this.filter.set((Object)filter);
    }

    public JavaFxSettingsManager getJavaFxSettingsManager() {
        return (JavaFxSettingsManager)this.javaFxSettingsManager.get();
    }

    public ObjectProperty<JavaFxSettingsManager> javaFxSettingsManagerProperty() {
        return this.javaFxSettingsManager;
    }

    public void setJavaFxSettingsManager(JavaFxSettingsManager javaFxSettingsManager) {
        this.javaFxSettingsManager.set((Object)javaFxSettingsManager);
    }

    public ObservableList<InstallationCategoryDTO> getInstallationCategories() {
        return this.installationCategories;
    }

    public Runnable getOnInstallationAdded() {
        return (Runnable)this.onInstallationAdded.get();
    }

    public ObjectProperty<Runnable> onInstallationAddedProperty() {
        return this.onInstallationAdded;
    }

    public void setOnInstallationAdded(Runnable onInstallationAdded) {
        this.onInstallationAdded.set((Object)onInstallationAdded);
    }

    public InstallationDTO getSelectedInstallation() {
        return (InstallationDTO)this.selectedInstallation.get();
    }

    public ObjectProperty<InstallationDTO> selectedInstallationProperty() {
        return this.selectedInstallation;
    }

    public void setSelectedInstallation(InstallationDTO selectedInstallation) {
        this.selectedInstallation.set((Object)selectedInstallation);
    }

    public OpenDetailsPanel getOpenedDetailsPanel() {
        return (OpenDetailsPanel)this.openedDetailsPanel.get();
    }

    public ObjectProperty<OpenDetailsPanel> openedDetailsPanelProperty() {
        return this.openedDetailsPanel;
    }

    public void setOpenedDetailsPanel(OpenDetailsPanel openDetailsPanel) {
        this.openedDetailsPanel.set((Object)openDetailsPanel);
    }

    @Override
    public void closeDetailsPanel() {
        this.setSelectedInstallation(null);
        this.setOpenedDetailsPanel(new None());
    }
}

