/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.engine.skin;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import org.phoenicis.engines.dto.EngineCategoryDTO;
import org.phoenicis.engines.dto.EngineDTO;
import org.phoenicis.engines.dto.EngineSubCategoryDTO;
import org.phoenicis.engines.dto.EngineVersionDTO;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.common.widgets.control.CombinedListWidget;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetElement;
import org.phoenicis.javafx.components.engine.control.EngineSubCategoryPanel;
import org.phoenicis.javafx.views.mainwindow.engines.EnginesFilter;

public class EngineSubCategoryPanelSkin
extends SkinBase<EngineSubCategoryPanel, EngineSubCategoryPanelSkin> {
    public EngineSubCategoryPanelSkin(EngineSubCategoryPanel control) {
        super(control);
    }

    @Override
    public void initialise() {
        ObservableList<EngineVersionDTO> filteredEngineVersions = this.createFilteredEngineVersions();
        CombinedListWidget<EngineVersionDTO> engineVersionsView = this.createListWidget(filteredEngineVersions);
        this.getChildren().setAll((Object[])new Node[]{engineVersionsView});
    }

    private ObservableList<EngineVersionDTO> createFilteredEngineVersions() {
        EnginesFilter filter = ((EngineSubCategoryPanel)((Object)this.getControl())).getFilter();
        EngineCategoryDTO engineCategory = ((EngineSubCategoryPanel)((Object)this.getControl())).getEngineCategory();
        EngineSubCategoryDTO engineSubCategory = ((EngineSubCategoryPanel)((Object)this.getControl())).getEngineSubCategory();
        FilteredList filteredEngineVersions = FXCollections.observableArrayList((Collection)engineSubCategory.getPackages()).sorted(EngineSubCategoryDTO.comparator().reversed()).filtered(filter.createFilter(engineCategory, engineSubCategory));
        filteredEngineVersions.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> filter.createFilter(engineCategory, engineSubCategory), (Observable[])new Observable[]{filter.searchTermProperty(), filter.selectedEngineCategoryProperty(), filter.showInstalledProperty(), filter.showNotInstalledProperty()}));
        return filteredEngineVersions;
    }

    private CombinedListWidget<EngineVersionDTO> createListWidget(ObservableList<EngineVersionDTO> filteredEngineVersions) {
        MappedList listWidgetEntries = new MappedList(filteredEngineVersions, engineVersion -> ListWidgetElement.create(engineVersion, Files.exists(Paths.get(((EngineSubCategoryPanel)((Object)((Object)this.getControl()))).getEnginesPath(), ((EngineSubCategoryPanel)((Object)((Object)this.getControl()))).getEngineCategory().getName().toLowerCase(), ((EngineSubCategoryPanel)((Object)((Object)this.getControl()))).getEngineSubCategory().getName(), engineVersion.getVersion()), new LinkOption[0])));
        CombinedListWidget<EngineVersionDTO> listWidget = new CombinedListWidget<EngineVersionDTO>((ObservableList<ListWidgetElement<EngineVersionDTO>>)listWidgetEntries);
        listWidget.selectedListWidgetProperty().bind(((EngineSubCategoryPanel)((Object)this.getControl())).selectedListWidgetProperty());
        listWidget.selectedElementProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                EngineVersionDTO engineItem = (EngineVersionDTO)newValue.getItem();
                HashMap<String, String> userData = new HashMap<String, String>();
                userData.put("Mono", engineItem.getMonoFile());
                userData.put("Gecko", engineItem.getGeckoFile());
                EngineDTO engineDTO = new EngineDTO.Builder().withCategory(((EngineSubCategoryPanel)((Object)((Object)this.getControl()))).getEngineCategory().getName()).withSubCategory(((EngineSubCategoryPanel)((Object)((Object)this.getControl()))).getEngineSubCategory().getName()).withVersion(engineItem.getVersion()).withUserData(userData).build();
                Optional.ofNullable(((EngineSubCategoryPanel)((Object)((Object)this.getControl()))).getOnEngineSelect()).ifPresent(onEngineSelect -> onEngineSelect.accept(engineDTO, ((EngineSubCategoryPanel)((Object)((Object)((Object)this.getControl())))).getEngine()));
            }
        });
        return listWidget;
    }
}

