/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.engine.skin;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ScrollPane;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.engines.dto.EngineCategoryDTO;
import org.phoenicis.javafx.components.common.control.SidebarGroup;
import org.phoenicis.javafx.components.common.skin.ExtendedSidebarSkinBase;
import org.phoenicis.javafx.components.engine.control.EngineSidebar;
import org.phoenicis.javafx.components.engine.control.EnginesSidebarToggleGroup;

public class EngineSidebarSkin
extends ExtendedSidebarSkinBase<EngineCategoryDTO, EngineSidebar, EngineSidebarSkin> {
    public EngineSidebarSkin(EngineSidebar control) {
        super(control);
    }

    @Override
    protected ScrollPane createMainContent() {
        return EngineSidebarSkin.createScrollPane(new Node[]{this.createSidebarToggleGroup(), EngineSidebarSkin.createSpacer(), this.createInstallationFilters()});
    }

    private EnginesSidebarToggleGroup createSidebarToggleGroup() {
        FilteredList filteredEngineCategories = ((EngineSidebar)((Object)this.getControl())).getItems().filtered(((EngineSidebar)((Object)this.getControl())).getFilter()::filter);
        filteredEngineCategories.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((EngineSidebar)((Object)((Object)this.getControl()))).getFilter()::filter, (Observable[])new Observable[]{((EngineSidebar)((Object)this.getControl())).searchTermProperty(), ((EngineSidebar)((Object)this.getControl())).showInstalledProperty(), ((EngineSidebar)((Object)this.getControl())).showNotInstalledProperty()}));
        EnginesSidebarToggleGroup categoryView = new EnginesSidebarToggleGroup((String)Localisation.tr((Object)"Engines"), (ObservableList<EngineCategoryDTO>)filteredEngineCategories);
        ((EngineSidebar)((Object)this.getControl())).selectedEngineCategoryProperty().bind(categoryView.selectedElementProperty());
        return categoryView;
    }

    private SidebarGroup<CheckBox> createInstallationFilters() {
        CheckBox installedCheck = new CheckBox((String)Localisation.tr((Object)"Installed"));
        installedCheck.getStyleClass().add((Object)"sidebarCheckBox");
        installedCheck.setSelected(true);
        ((EngineSidebar)((Object)this.getControl())).showInstalledProperty().bind((ObservableValue)installedCheck.selectedProperty());
        CheckBox notInstalledCheck = new CheckBox((String)Localisation.tr((Object)"Not installed"));
        notInstalledCheck.getStyleClass().add((Object)"sidebarCheckBox");
        notInstalledCheck.setSelected(true);
        ((EngineSidebar)((Object)this.getControl())).showNotInstalledProperty().bind((ObservableValue)notInstalledCheck.selectedProperty());
        SidebarGroup<CheckBox> installationFilterGroup = new SidebarGroup<CheckBox>();
        installationFilterGroup.getComponents().addAll((Object[])new CheckBox[]{installedCheck, notInstalledCheck});
        return installationFilterGroup;
    }
}

