/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.engine.skin;

import java.util.Map;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.engines.Engine;
import org.phoenicis.engines.dto.EngineDTO;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.engine.control.EngineInformationPanel;
import org.phoenicis.javafx.dialogs.ErrorDialog;
import org.phoenicis.javafx.utils.CollectionBindings;
import org.phoenicis.javafx.utils.StringBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineInformationPanelSkin
extends SkinBase<EngineInformationPanel, EngineInformationPanelSkin> {
    private final Logger LOGGER = LoggerFactory.getLogger(EngineInformationPanelSkin.class);
    private final StringBinding engineVersionName = StringBindings.map(((EngineInformationPanel)((Object)this.getControl())).engineDTOProperty(), EngineDTO::getVersion);
    private final ObservableMap<String, String> engineUserData = CollectionBindings.mapToMap(((EngineInformationPanel)((Object)this.getControl())).engineDTOProperty(), EngineDTO::getUserData);

    public EngineInformationPanelSkin(EngineInformationPanel control) {
        super(control);
    }

    @Override
    public void initialise() {
        GridPane informationContentPane = new GridPane();
        informationContentPane.getStyleClass().add((Object)"grid");
        this.engineUserData.addListener(invalidation -> this.updateUserData(informationContentPane));
        this.updateUserData(informationContentPane);
        HBox buttonBox = this.createEngineButtons();
        Region informationContentSpacer = new Region();
        informationContentSpacer.getStyleClass().add((Object)"engineSpacer");
        Region buttonBoxSpacer = new Region();
        buttonBoxSpacer.getStyleClass().add((Object)"engineSpacer");
        VBox container = new VBox(new Node[]{informationContentPane, informationContentSpacer, buttonBox, buttonBoxSpacer});
        this.getChildren().add((Object)container);
    }

    private HBox createEngineButtons() {
        BooleanBinding engineInstalledProperty = Bindings.createBooleanBinding(() -> {
            Engine engine = ((EngineInformationPanel)((Object)((Object)this.getControl()))).getEngine();
            EngineDTO engineDTO = ((EngineInformationPanel)((Object)((Object)this.getControl()))).getEngineDTO();
            if (engine == null || engineDTO == null) {
                return true;
            }
            return engine.isInstalled(engineDTO.getSubCategory(), engineDTO.getVersion());
        }, (Observable[])new Observable[]{((EngineInformationPanel)((Object)this.getControl())).engineProperty(), ((EngineInformationPanel)((Object)this.getControl())).engineDTOProperty()});
        Button installButton = new Button((String)Localisation.tr((Object)"Install"));
        installButton.disableProperty().bind((ObservableValue)engineInstalledProperty);
        installButton.setOnMouseClicked(evt -> {
            try {
                Optional.ofNullable(((EngineInformationPanel)((Object)((Object)this.getControl()))).getOnEngineInstall()).ifPresent(onEngineInstall -> onEngineInstall.accept(((EngineInformationPanel)((Object)((Object)((Object)this.getControl())))).getEngineDTO()));
            }
            catch (IllegalArgumentException e) {
                this.LOGGER.error("Failed to get engine", (Throwable)e);
                ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"An error occurred while installing the engine")).withOwner(((EngineInformationPanel)((Object)((Object)this.getControl()))).getScene().getWindow()).withException(e).build();
                errorDialog.showAndWait();
            }
        });
        Button deleteButton = new Button((String)Localisation.tr((Object)"Delete"));
        deleteButton.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)engineInstalledProperty));
        deleteButton.setOnMouseClicked(evt -> {
            try {
                Optional.ofNullable(((EngineInformationPanel)((Object)((Object)this.getControl()))).getOnEngineDelete()).ifPresent(onEngineDelete -> onEngineDelete.accept(((EngineInformationPanel)((Object)((Object)((Object)this.getControl())))).getEngineDTO()));
            }
            catch (IllegalArgumentException e) {
                this.LOGGER.error("Failed to get engine", (Throwable)e);
                ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"An error occurred while deleting the engine")).withOwner(((EngineInformationPanel)((Object)((Object)this.getControl()))).getScene().getWindow()).withException(e).build();
                errorDialog.showAndWait();
            }
        });
        HBox buttonBox = new HBox(new Node[]{installButton, deleteButton});
        buttonBox.getStyleClass().add((Object)"engineButtons");
        return buttonBox;
    }

    private void updateUserData(GridPane userDataGrid) {
        userDataGrid.getChildren().clear();
        Text versionLabel = new Text((String)Localisation.tr((Object)"Version:"));
        versionLabel.getStyleClass().add((Object)"captionTitle");
        Label name = new Label();
        name.textProperty().bind((ObservableValue)this.engineVersionName);
        name.setWrapText(true);
        userDataGrid.addRow(0, new Node[]{versionLabel, name});
        for (Map.Entry userData : this.engineUserData.entrySet()) {
            int row = userDataGrid.getRowCount();
            Text userDataLabel = new Text((String)Localisation.tr((Object)((String)userData.getKey())));
            userDataLabel.getStyleClass().add((Object)"captionTitle");
            Label path = new Label((String)userData.getValue());
            path.setWrapText(true);
            userDataGrid.addRow(row, new Node[]{userDataLabel, path});
        }
    }
}

