/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.engine.control;

import java.util.function.BiConsumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.phoenicis.engines.Engine;
import org.phoenicis.engines.dto.EngineCategoryDTO;
import org.phoenicis.engines.dto.EngineDTO;
import org.phoenicis.engines.dto.EngineSubCategoryDTO;
import org.phoenicis.javafx.components.common.control.ControlBase;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetType;
import org.phoenicis.javafx.components.engine.skin.EngineSubCategoryPanelSkin;
import org.phoenicis.javafx.views.mainwindow.engines.EnginesFilter;

public class EngineSubCategoryPanel
extends ControlBase<EngineSubCategoryPanel, EngineSubCategoryPanelSkin> {
    private final ObjectProperty<EngineCategoryDTO> engineCategory;
    private final ObjectProperty<EngineSubCategoryDTO> engineSubCategory;
    private final StringProperty enginesPath;
    private final ObjectProperty<Engine> engine;
    private final ObjectProperty<EnginesFilter> filter;
    private final ObjectProperty<ListWidgetType> selectedListWidget;
    private final ObjectProperty<BiConsumer<EngineDTO, Engine>> onEngineSelect;

    public EngineSubCategoryPanel(ObjectProperty<EngineCategoryDTO> engineCategory, ObjectProperty<EngineSubCategoryDTO> engineSubCategory, StringProperty enginesPath, ObjectProperty<Engine> engine, ObjectProperty<EnginesFilter> filter, ObjectProperty<ListWidgetType> selectedListWidget, ObjectProperty<BiConsumer<EngineDTO, Engine>> onEngineSelect) {
        this.engineCategory = engineCategory;
        this.engineSubCategory = engineSubCategory;
        this.enginesPath = enginesPath;
        this.engine = engine;
        this.filter = filter;
        this.selectedListWidget = selectedListWidget;
        this.onEngineSelect = onEngineSelect;
    }

    public EngineSubCategoryPanel() {
        this((ObjectProperty<EngineCategoryDTO>)new SimpleObjectProperty(), (ObjectProperty<EngineSubCategoryDTO>)new SimpleObjectProperty(), (StringProperty)new SimpleStringProperty(), (ObjectProperty<Engine>)new SimpleObjectProperty(), (ObjectProperty<EnginesFilter>)new SimpleObjectProperty(), (ObjectProperty<ListWidgetType>)new SimpleObjectProperty(), (ObjectProperty<BiConsumer<EngineDTO, Engine>>)new SimpleObjectProperty());
    }

    @Override
    public EngineSubCategoryPanelSkin createSkin() {
        return new EngineSubCategoryPanelSkin(this);
    }

    public boolean notEmpty(EnginesFilter filter) {
        return this.getEngineSubCategory().getPackages().stream().anyMatch(filter.createFilter(this.getEngineCategory(), this.getEngineSubCategory()));
    }

    public EngineCategoryDTO getEngineCategory() {
        return (EngineCategoryDTO)this.engineCategory.get();
    }

    public ObjectProperty<EngineCategoryDTO> engineCategoryProperty() {
        return this.engineCategory;
    }

    public void setEngineCategory(EngineCategoryDTO engineCategory) {
        this.engineCategory.set((Object)engineCategory);
    }

    public EngineSubCategoryDTO getEngineSubCategory() {
        return (EngineSubCategoryDTO)this.engineSubCategory.get();
    }

    public ObjectProperty<EngineSubCategoryDTO> engineSubCategoryProperty() {
        return this.engineSubCategory;
    }

    public void setEngineSubCategory(EngineSubCategoryDTO engineSubCategory) {
        this.engineSubCategory.set((Object)engineSubCategory);
    }

    public String getEnginesPath() {
        return (String)this.enginesPath.get();
    }

    public StringProperty enginesPathProperty() {
        return this.enginesPath;
    }

    public void setEnginesPath(String enginesPath) {
        this.enginesPath.set((Object)enginesPath);
    }

    public Engine getEngine() {
        return (Engine)this.engine.get();
    }

    public ObjectProperty<Engine> engineProperty() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine.set((Object)engine);
    }

    public EnginesFilter getFilter() {
        return (EnginesFilter)this.filter.get();
    }

    public ObjectProperty<EnginesFilter> filterProperty() {
        return this.filter;
    }

    public void setFilter(EnginesFilter filter) {
        this.filter.set((Object)filter);
    }

    public ListWidgetType getSelectedListWidget() {
        return (ListWidgetType)((Object)this.selectedListWidget.get());
    }

    public ObjectProperty<ListWidgetType> selectedListWidgetProperty() {
        return this.selectedListWidget;
    }

    public void setSelectedListWidget(ListWidgetType selectedListWidget) {
        this.selectedListWidget.set((Object)selectedListWidget);
    }

    public BiConsumer<EngineDTO, Engine> getOnEngineSelect() {
        return (BiConsumer)this.onEngineSelect.get();
    }

    public ObjectProperty<BiConsumer<EngineDTO, Engine>> onEngineSelectProperty() {
        return this.onEngineSelect;
    }

    public void setOnEngineSelect(BiConsumer<EngineDTO, Engine> onEngineSelect) {
        this.onEngineSelect.set(onEngineSelect);
    }
}

