/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.container.skin;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.Node;
import org.phoenicis.containers.dto.ContainerCategoryDTO;
import org.phoenicis.containers.dto.ContainerDTO;
import org.phoenicis.engines.EngineSetting;
import org.phoenicis.javafx.collections.ConcatenatedList;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.components.common.control.DetailsPanel;
import org.phoenicis.javafx.components.common.control.SidebarBase;
import org.phoenicis.javafx.components.common.panelstates.None;
import org.phoenicis.javafx.components.common.skin.FeaturePanelSkin;
import org.phoenicis.javafx.components.common.widgets.control.CombinedListWidget;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetElement;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetType;
import org.phoenicis.javafx.components.container.control.ContainerInformationPanel;
import org.phoenicis.javafx.components.container.control.ContainerSidebar;
import org.phoenicis.javafx.components.container.control.ContainersFeaturePanel;
import org.phoenicis.javafx.components.container.panelstates.ContainerInformation;
import org.phoenicis.javafx.settings.JavaFxSettingsManager;
import org.phoenicis.javafx.utils.SwitchBinding;
import org.phoenicis.repository.dto.ApplicationDTO;

public class ContainersFeaturePanelSkin
extends FeaturePanelSkin<ContainersFeaturePanel, ContainersFeaturePanelSkin> {
    private final ObjectProperty<ListWidgetType> selectedListWidget = new SimpleObjectProperty();

    public ContainersFeaturePanelSkin(ContainersFeaturePanel control) {
        super(control);
    }

    @Override
    public ObjectExpression<SidebarBase<?, ?, ?>> createSidebar() {
        SortedList sortedCategories = ((ContainersFeaturePanel)((Object)this.getControl())).getCategories().sorted(Comparator.comparing(ContainerCategoryDTO::getName));
        ContainerSidebar sidebar = new ContainerSidebar(((ContainersFeaturePanel)((Object)this.getControl())).getFilter(), (ObservableList<ContainerCategoryDTO>)sortedCategories, this.selectedListWidget);
        sidebar.setSelectedListWidget(Optional.ofNullable(((ContainersFeaturePanel)((Object)this.getControl())).getJavaFxSettingsManager()).map(JavaFxSettingsManager::getContainersListType).orElse(ListWidgetType.ICONS_LIST));
        sidebar.selectedListWidgetProperty().addListener((observable, oldValue, newValue) -> {
            JavaFxSettingsManager javaFxSettingsManager = ((ContainersFeaturePanel)((Object)((Object)this.getControl()))).getJavaFxSettingsManager();
            if (newValue != null) {
                javaFxSettingsManager.setContainersListType((ListWidgetType)((Object)newValue));
                javaFxSettingsManager.save();
            }
        });
        return new SimpleObjectProperty((Object)sidebar);
    }

    @Override
    public ObjectExpression<Node> createContent() {
        FilteredList filteredContainers = ConcatenatedList.create((ObservableList)new MappedList((ObservableList)((ContainersFeaturePanel)((Object)this.getControl())).getCategories().sorted(Comparator.comparing(ContainerCategoryDTO::getName)), ContainerCategoryDTO::getContainers)).sorted(Comparator.comparing(ContainerDTO::getName)).filtered(((ContainersFeaturePanel)((Object)this.getControl())).getFilter()::filter);
        filteredContainers.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((ContainersFeaturePanel)((Object)((Object)this.getControl()))).getFilter()::filter, (Observable[])new Observable[]{((ContainersFeaturePanel)((Object)this.getControl())).getFilter().searchTermProperty()}));
        MappedList listWidgetEntries = new MappedList((ObservableList)filteredContainers, ListWidgetElement::create);
        CombinedListWidget combinedListWidget = new CombinedListWidget(listWidgetEntries, this.selectedListWidget);
        ((ContainersFeaturePanel)((Object)this.getControl())).selectedContainerProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                combinedListWidget.select(newValue);
            } else {
                combinedListWidget.deselect();
            }
        });
        combinedListWidget.selectedElementProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                ContainerDTO selectedItem = (ContainerDTO)newValue.getItem();
                ((ContainersFeaturePanel)((Object)((Object)this.getControl()))).setSelectedContainer(selectedItem);
                ((ContainersFeaturePanel)((Object)((Object)this.getControl()))).setOpenedDetailsPanel(new ContainerInformation(selectedItem));
            } else {
                ((ContainersFeaturePanel)((Object)((Object)this.getControl()))).setSelectedContainer(null);
                ((ContainersFeaturePanel)((Object)((Object)this.getControl()))).setOpenedDetailsPanel(new None());
            }
        });
        return new SimpleObjectProperty(combinedListWidget);
    }

    @Override
    public ObjectExpression<DetailsPanel> createDetailsPanel() {
        return SwitchBinding.builder(((ContainersFeaturePanel)((Object)this.getControl())).openedDetailsPanelProperty()).withCase(ContainerInformation.class, this::createContainerInformationDetailsPanel).withCase(None.class, action -> null).build();
    }

    private DetailsPanel createContainerInformationDetailsPanel(ContainerInformation action) {
        ContainerDTO container = action.getContainer();
        ContainerInformationPanel containerInformationPanel = new ContainerInformationPanel();
        containerInformationPanel.setContainer(container);
        containerInformationPanel.enginesManagerProperty().bind(((ContainersFeaturePanel)((Object)this.getControl())).enginesManagerProperty());
        containerInformationPanel.verbsManagerProperty().bind(((ContainersFeaturePanel)((Object)this.getControl())).verbsManagerProperty());
        containerInformationPanel.engineToolsManagerProperty().bind(((ContainersFeaturePanel)((Object)this.getControl())).engineToolsManagerProperty());
        containerInformationPanel.setOnDeleteContainer(((ContainersFeaturePanel)((Object)this.getControl()))::deleteContainer);
        containerInformationPanel.setOnChangeEngineVersion(((ContainersFeaturePanel)((Object)this.getControl()))::changeEngineVersion);
        containerInformationPanel.setOnOpenFileBrowser(((ContainersFeaturePanel)((Object)this.getControl()))::openFileBrowser);
        ((ContainersFeaturePanel)((Object)this.getControl())).getEngineSettings().addListener(invalidation -> this.updateEngineSettings(containerInformationPanel));
        ((ContainersFeaturePanel)((Object)this.getControl())).getVerbs().addListener(invalidation -> this.updateVerbs(containerInformationPanel));
        ((ContainersFeaturePanel)((Object)this.getControl())).getEngineTools().addListener(invalidation -> this.updateEngineTools(containerInformationPanel));
        this.updateEngineSettings(containerInformationPanel);
        this.updateVerbs(containerInformationPanel);
        this.updateEngineTools(containerInformationPanel);
        DetailsPanel containerDetailsPanel = new DetailsPanel();
        containerDetailsPanel.setTitle(container.getName());
        containerDetailsPanel.setContent((Node)containerInformationPanel);
        containerDetailsPanel.setOnClose(((ContainersFeaturePanel)((Object)this.getControl()))::closeDetailsPanel);
        containerDetailsPanel.prefWidthProperty().bind((ObservableValue)((ContainersFeaturePanel)((Object)this.getControl())).widthProperty().divide(3));
        return containerDetailsPanel;
    }

    private void updateEngineSettings(ContainerInformationPanel containerInformationPanel) {
        ObservableMap<String, List<EngineSetting>> engineSettings = ((ContainersFeaturePanel)((Object)this.getControl())).getEngineSettings();
        ContainerDTO container = containerInformationPanel.getContainer();
        if (container != null && engineSettings.containsKey((Object)container.getEngine().toLowerCase())) {
            containerInformationPanel.getEngineSettings().setAll((Collection)engineSettings.get((Object)container.getEngine().toLowerCase()));
        } else {
            containerInformationPanel.getEngineSettings().clear();
        }
    }

    private void updateVerbs(ContainerInformationPanel containerInformationPanel) {
        ObservableMap<String, ApplicationDTO> verbs = ((ContainersFeaturePanel)((Object)this.getControl())).getVerbs();
        ContainerDTO container = containerInformationPanel.getContainer();
        if (container != null && verbs.containsKey((Object)container.getEngine().toLowerCase())) {
            containerInformationPanel.setVerbs((ApplicationDTO)verbs.get((Object)container.getEngine().toLowerCase()));
        } else {
            containerInformationPanel.setVerbs(null);
        }
    }

    private void updateEngineTools(ContainerInformationPanel containerInformationPanel) {
        ObservableMap<String, ApplicationDTO> engineTools = ((ContainersFeaturePanel)((Object)this.getControl())).getEngineTools();
        ContainerDTO container = containerInformationPanel.getContainer();
        if (container != null && engineTools.containsKey((Object)container.getEngine().toLowerCase())) {
            containerInformationPanel.setEngineTools((ApplicationDTO)engineTools.get((Object)container.getEngine().toLowerCase()));
        } else {
            containerInformationPanel.setEngineTools(null);
        }
    }
}

