/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.container.skin;

import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.containers.dto.ContainerDTO;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.container.control.ContainerVerbsPanel;
import org.phoenicis.javafx.dialogs.ErrorDialog;
import org.phoenicis.javafx.dialogs.ListConfirmDialog;
import org.phoenicis.repository.dto.ScriptDTO;

public class ContainerVerbsPanelSkin
extends SkinBase<ContainerVerbsPanel, ContainerVerbsPanelSkin> {
    public ContainerVerbsPanelSkin(ContainerVerbsPanel control) {
        super(control);
    }

    @Override
    public void initialise() {
        Text title = new Text((String)Localisation.tr((Object)"Verbs"));
        title.getStyleClass().add((Object)"title");
        GridPane verbs = new GridPane();
        verbs.getStyleClass().add((Object)"verb-grid");
        ((ContainerVerbsPanel)((Object)this.getControl())).getVerbScripts().addListener(invalidation -> this.updateVerbs(verbs));
        this.updateVerbs(verbs);
        ScrollPane verbScrollPanel = new ScrollPane((Node)verbs);
        verbScrollPanel.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        verbScrollPanel.setFitToWidth(true);
        VBox.setVgrow((Node)verbScrollPanel, (Priority)Priority.ALWAYS);
        HBox verbManagementButtons = this.createVerbManagementButtons(verbs);
        verbManagementButtons.getStyleClass().add((Object)"verb-management-button-container");
        VBox container = new VBox(new Node[]{title, verbScrollPanel, verbManagementButtons});
        container.getStyleClass().addAll((Object[])new String[]{"container-details-panel", "container-verbs-panel"});
        this.getChildren().setAll((Object[])new Node[]{container});
    }

    private HBox createVerbManagementButtons(GridPane verbs) {
        Button installButton = new Button((String)Localisation.tr((Object)"Install selected"));
        installButton.disableProperty().bind((ObservableValue)((ContainerVerbsPanel)((Object)this.getControl())).lockVerbsProperty());
        installButton.setOnAction(event -> {
            ((ContainerVerbsPanel)((Object)((Object)this.getControl()))).setLockVerbs(true);
            ContainerDTO container = ((ContainerVerbsPanel)((Object)((Object)this.getControl()))).getContainer();
            List installationVerbs = verbs.getChildren().stream().filter(element -> element instanceof CheckBox && ((CheckBox)element).isSelected()).map(GridPane::getRowIndex).map(arg_0 -> ((ContainerVerbsPanel)((Object)((Object)this.getControl()))).getVerbScripts().get(arg_0)).collect(Collectors.toList());
            List<String> verbNames = installationVerbs.stream().map(ScriptDTO::getScriptName).collect(Collectors.toList());
            ListConfirmDialog confirmDialog = ListConfirmDialog.builder().withTitle((String)Localisation.tr((Object)"Install Verbs")).withMessage((String)Localisation.tr((Object)"Are you sure you want to install the following Verbs:")).withConfirmItems(verbNames).withOwner(((ContainerVerbsPanel)((Object)((Object)this.getControl()))).getScene().getWindow()).withYesCallback(() -> {
                List verbIds = installationVerbs.stream().map(ScriptDTO::getId).collect(Collectors.toList());
                ((ContainerVerbsPanel)((Object)((Object)((Object)this.getControl())))).getVerbsManager().installVerbs(container.getEngine().toLowerCase(), container.getName(), verbIds, () -> ((ContainerVerbsPanel)((Object)((Object)((Object)((Object)this.getControl()))))).setLockVerbs(false), e -> Platform.runLater(() -> {
                    ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error installing Verbs")).withException((Exception)e).build();
                    errorDialog.showAndWait();
                }));
            }).build();
            confirmDialog.showAndCallback();
            ((ContainerVerbsPanel)((Object)((Object)this.getControl()))).setLockVerbs(false);
        });
        Button clearButton = new Button((String)Localisation.tr((Object)"Clear selection"));
        clearButton.disableProperty().bind((ObservableValue)((ContainerVerbsPanel)((Object)this.getControl())).lockVerbsProperty());
        clearButton.setOnAction(event -> verbs.getChildren().stream().filter(element -> element instanceof CheckBox).map(element -> (CheckBox)element).forEach(verbCheckBox -> verbCheckBox.setSelected(false)));
        return new HBox(new Node[]{installButton, clearButton});
    }

    private void updateVerbs(GridPane verbs) {
        verbs.getChildren().clear();
        for (ScriptDTO verb : ((ContainerVerbsPanel)((Object)this.getControl())).getVerbScripts()) {
            int row = verbs.getRowCount();
            CheckBox verbCheck = new CheckBox();
            verbCheck.disableProperty().bind((ObservableValue)((ContainerVerbsPanel)((Object)this.getControl())).lockVerbsProperty());
            Label verbName = new Label(verb.getScriptName());
            verbName.setOnMouseClicked(event -> verbCheck.fire());
            GridPane.setHgrow((Node)verbName, (Priority)Priority.ALWAYS);
            verbs.addRow(row, new Node[]{verbCheck, verbName});
        }
    }
}

