/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.container.skin;

import java.io.File;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.containers.dto.ContainerDTO;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.container.control.ContainerToolsPanel;
import org.phoenicis.javafx.dialogs.ErrorDialog;

public class ContainerToolsPanelSkin
extends SkinBase<ContainerToolsPanel, ContainerToolsPanelSkin> {
    public ContainerToolsPanelSkin(ContainerToolsPanel control) {
        super(control);
    }

    @Override
    public void initialise() {
        Text title = new Text((String)Localisation.tr((Object)"Tools"));
        title.getStyleClass().add((Object)"title");
        TilePane toolsContainer = this.createToolsContainer();
        toolsContainer.getStyleClass().add((Object)"tool-grid");
        VBox toolsPane = new VBox(new Node[]{title, toolsContainer});
        toolsPane.getStyleClass().addAll((Object[])new String[]{"container-details-panel", "container-tools-panel"});
        this.getChildren().setAll((Object[])new Node[]{toolsPane});
    }

    private TilePane createToolsContainer() {
        TilePane toolsContainer = new TilePane();
        Button runExecutable = new Button((String)Localisation.tr((Object)"Run executable"));
        runExecutable.getStyleClass().addAll((Object[])new String[]{"toolButton", "runExecutable"});
        runExecutable.setOnMouseClicked(event -> {
            File file;
            ((ContainerToolsPanel)((Object)((Object)this.getControl()))).setLockTools(true);
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle((String)Localisation.tr((Object)"Choose executable..."));
            File containerDir = new File(((ContainerToolsPanel)((Object)((Object)this.getControl()))).getContainer().getPath());
            if (containerDir.canRead()) {
                fileChooser.setInitialDirectory(containerDir);
            }
            if ((file = fileChooser.showOpenDialog(((ContainerToolsPanel)((Object)((Object)this.getControl()))).getScene().getWindow())) != null) {
                ContainerDTO container = ((ContainerToolsPanel)((Object)((Object)this.getControl()))).getContainer();
                String engineId = container.getEngine().toLowerCase();
                ((ContainerToolsPanel)((Object)((Object)this.getControl()))).getEnginesManager().getEngine(engineId, engine -> {
                    engine.setWorkingContainer(container.getName());
                    engine.run(file.getAbsolutePath(), new String[0], container.getPath(), false, true, new HashMap());
                    ((ContainerToolsPanel)((Object)((Object)((Object)this.getControl())))).setLockTools(false);
                }, exception -> Platform.runLater(() -> {
                    ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error")).withOwner(((ContainerToolsPanel)((Object)((Object)((Object)((Object)this.getControl()))))).getScene().getWindow()).withException((Exception)exception).build();
                    errorDialog.showAndWait();
                }));
            } else {
                ((ContainerToolsPanel)((Object)((Object)this.getControl()))).setLockTools(false);
            }
        });
        toolsContainer.getChildren().add((Object)runExecutable);
        return toolsContainer;
    }
}

