/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.container.skin;

import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.containers.dto.ContainerDTO;
import org.phoenicis.containers.dto.WinePrefixContainerDTO;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.container.control.ContainerOverviewPanel;
import org.phoenicis.javafx.utils.StringBindings;

public class ContainerOverviewPanelSkin
extends SkinBase<ContainerOverviewPanel, ContainerOverviewPanelSkin> {
    public ContainerOverviewPanelSkin(ContainerOverviewPanel control) {
        super(control);
    }

    @Override
    public void initialise() {
        Text title = new Text((String)Localisation.tr((Object)"Information"));
        title.getStyleClass().add((Object)"title");
        GridPane overviewGrid = new GridPane();
        overviewGrid.getStyleClass().add((Object)"information-grid");
        this.addName(overviewGrid);
        this.addPath(overviewGrid);
        this.addInstalledShortcuts(overviewGrid);
        this.addVersion(overviewGrid);
        this.addArchitecture(overviewGrid);
        this.addDistribution(overviewGrid);
        HBox managementButtonContainer = this.createManagementButtonContainer();
        managementButtonContainer.getStyleClass().add((Object)"container-management-button-container");
        VBox container = new VBox(new Node[]{title, overviewGrid, managementButtonContainer});
        container.getStyleClass().addAll((Object[])new String[]{"container-details-panel", "container-overview-panel"});
        this.getChildren().addAll((Object[])new Node[]{container});
    }

    private HBox createManagementButtonContainer() {
        Button deleteButton = new Button((String)Localisation.tr((Object)"Delete container"));
        deleteButton.setOnMouseClicked(event -> Optional.ofNullable(((ContainerOverviewPanel)((Object)((Object)this.getControl()))).getOnDeleteContainer()).ifPresent(onDeleteContainer -> onDeleteContainer.accept(((ContainerOverviewPanel)((Object)((Object)((Object)this.getControl())))).getContainer())));
        Button changeEngineVersionButton = new Button((String)Localisation.tr((Object)"Change engine version"));
        changeEngineVersionButton.setOnMouseClicked(event -> Optional.ofNullable(((ContainerOverviewPanel)((Object)((Object)this.getControl()))).getOnChangeEngineVersion()).ifPresent(onChangeEngine -> onChangeEngine.accept(((ContainerOverviewPanel)((Object)((Object)((Object)this.getControl())))).getContainer())));
        Button openFileBrowserButton = new Button((String)Localisation.tr((Object)"Open in file browser"));
        openFileBrowserButton.setOnMouseClicked(event -> Optional.ofNullable(((ContainerOverviewPanel)((Object)((Object)this.getControl()))).getOnOpenFileBrowser()).ifPresent(onOpenFileBrowser -> onOpenFileBrowser.accept(((ContainerOverviewPanel)((Object)((Object)((Object)this.getControl())))).getContainer())));
        return new HBox(new Node[]{deleteButton, changeEngineVersionButton, openFileBrowserButton});
    }

    private void addName(GridPane overviewGrid) {
        int row = overviewGrid.getRowCount();
        Text nameDescription = new Text((String)Localisation.tr((Object)"Name:"));
        nameDescription.getStyleClass().add((Object)"captionTitle");
        Label nameOutput = new Label();
        nameOutput.textProperty().bind((ObservableValue)StringBindings.map(((ContainerOverviewPanel)((Object)this.getControl())).containerProperty(), ContainerDTO::getName));
        nameOutput.setWrapText(true);
        overviewGrid.addRow(row, new Node[]{nameDescription, nameOutput});
    }

    private void addPath(GridPane overviewGrid) {
        int row = overviewGrid.getRowCount();
        Text pathDescription = new Text((String)Localisation.tr((Object)"Path:"));
        pathDescription.getStyleClass().add((Object)"captionTitle");
        Label pathOutput = new Label();
        pathOutput.textProperty().bind((ObservableValue)StringBindings.map(((ContainerOverviewPanel)((Object)this.getControl())).containerProperty(), ContainerDTO::getPath));
        pathOutput.setWrapText(true);
        overviewGrid.addRow(row, new Node[]{pathDescription, pathOutput});
    }

    private void addInstalledShortcuts(GridPane overviewGrid) {
        int row = overviewGrid.getRowCount();
        Text installedShortcutsDescription = new Text((String)Localisation.tr((Object)"Installed shortcuts:"));
        installedShortcutsDescription.getStyleClass().add((Object)"captionTitle");
        Label installedShortcutsOutput = new Label();
        installedShortcutsOutput.textProperty().bind((ObservableValue)StringBindings.map(((ContainerOverviewPanel)((Object)this.getControl())).containerProperty(), container -> container.getInstalledShortcuts().stream().map(shortcutDTO -> shortcutDTO.getInfo().getName()).collect(Collectors.joining("; "))));
        installedShortcutsOutput.setWrapText(true);
        overviewGrid.addRow(row, new Node[]{installedShortcutsDescription, installedShortcutsOutput});
    }

    private void addVersion(GridPane overviewGrid) {
        int row = overviewGrid.getRowCount();
        Text versionDescription = new Text((String)Localisation.tr((Object)"Wine version:"));
        versionDescription.getStyleClass().add((Object)"captionTitle");
        Label versionOutput = new Label();
        versionOutput.textProperty().bind((ObservableValue)StringBindings.map(((ContainerOverviewPanel)((Object)this.getControl())).containerProperty(), WinePrefixContainerDTO::getVersion));
        versionOutput.setWrapText(true);
        overviewGrid.addRow(row, new Node[]{versionDescription, versionOutput});
    }

    private void addArchitecture(GridPane overviewGrid) {
        int row = overviewGrid.getRowCount();
        Text architectureDescription = new Text((String)Localisation.tr((Object)"Wine architecture:"));
        architectureDescription.getStyleClass().add((Object)"captionTitle");
        Label architectureOutput = new Label();
        architectureOutput.textProperty().bind((ObservableValue)StringBindings.map(((ContainerOverviewPanel)((Object)this.getControl())).containerProperty(), WinePrefixContainerDTO::getArchitecture));
        architectureOutput.setWrapText(true);
        overviewGrid.addRow(row, new Node[]{architectureDescription, architectureOutput});
    }

    private void addDistribution(GridPane overviewGrid) {
        int row = overviewGrid.getRowCount();
        Text distributionDescription = new Text((String)Localisation.tr((Object)"Wine distribution:"));
        distributionDescription.getStyleClass().add((Object)"captionTitle");
        Label distributionOutput = new Label();
        distributionOutput.textProperty().bind((ObservableValue)StringBindings.map(((ContainerOverviewPanel)((Object)this.getControl())).containerProperty(), WinePrefixContainerDTO::getDistribution));
        distributionOutput.setWrapText(true);
        overviewGrid.addRow(row, new Node[]{distributionDescription, distributionOutput});
    }
}

