/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.container.skin;

import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.containers.dto.WinePrefixContainerDTO;
import org.phoenicis.javafx.collections.ConcatenatedList;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.container.control.ContainerEngineSettingsPanel;
import org.phoenicis.javafx.components.container.control.ContainerEngineToolsPanel;
import org.phoenicis.javafx.components.container.control.ContainerInformationPanel;
import org.phoenicis.javafx.components.container.control.ContainerOverviewPanel;
import org.phoenicis.javafx.components.container.control.ContainerToolsPanel;
import org.phoenicis.javafx.components.container.control.ContainerVerbsPanel;
import org.phoenicis.javafx.utils.CollectionBindings;
import org.phoenicis.javafx.utils.ObjectBindings;

public class ContainerInformationPanelSkin
extends SkinBase<ContainerInformationPanel, ContainerInformationPanelSkin> {
    private final ObservableList<Tab> concatenatedTabs;

    public ContainerInformationPanelSkin(ContainerInformationPanel control) {
        super(control);
        ObservableList overviewTab = FXCollections.singletonObservableList((Object)this.createContainerOverviewTab());
        ObjectBinding engineSettingsBinding = Bindings.when((ObservableBooleanValue)Bindings.isNotEmpty(((ContainerInformationPanel)((Object)this.getControl())).getEngineSettings())).then((Object)this.createContainerEngineSettingsTab()).otherwise((ObservableObjectValue)new SimpleObjectProperty());
        ObservableList engineSettingsTab = CollectionBindings.mapToList(engineSettingsBinding, engineSettings -> Optional.ofNullable(engineSettings).map(List::of).orElse(List.of()));
        Tab verbsTabInstance = this.createContainerVerbsTab();
        ObservableList verbsTab = CollectionBindings.mapToList(((ContainerInformationPanel)((Object)this.getControl())).verbsProperty(), verbs -> verbs != null ? List.of(verbsTabInstance) : List.of());
        Tab engineToolsTabInstance = this.createContainerEngineToolsTab();
        ObservableList engineToolsTab = CollectionBindings.mapToList(((ContainerInformationPanel)((Object)this.getControl())).engineToolsProperty(), engineTools -> engineTools != null ? List.of(engineToolsTabInstance) : List.of());
        ObservableList toolsTab = FXCollections.singletonObservableList((Object)this.createContainerToolsTab());
        this.concatenatedTabs = ConcatenatedList.create((ObservableList[])new ObservableList[]{overviewTab, engineSettingsTab, verbsTab, engineToolsTab, toolsTab});
    }

    @Override
    public void initialise() {
        TabPane container = new TabPane();
        container.getStyleClass().add((Object)"container-information-panel");
        Bindings.bindContent((List)container.getTabs(), this.concatenatedTabs);
        this.getChildren().addAll((Object[])new Node[]{container});
    }

    private Tab createContainerOverviewTab() {
        ContainerOverviewPanel containerOverviewPanel = new ContainerOverviewPanel();
        containerOverviewPanel.containerProperty().bind(ObjectBindings.map(((ContainerInformationPanel)((Object)this.getControl())).containerProperty(), container -> (WinePrefixContainerDTO)container));
        containerOverviewPanel.onDeleteContainerProperty().bind(((ContainerInformationPanel)((Object)this.getControl())).onDeleteContainerProperty());
        containerOverviewPanel.onChangeEngineVersionProperty().bind(((ContainerInformationPanel)((Object)this.getControl())).onChangeEngineVersionProperty());
        containerOverviewPanel.onOpenFileBrowserProperty().bind(((ContainerInformationPanel)((Object)this.getControl())).onOpenFileBrowserProperty());
        Tab containerOverviewTab = new Tab((String)Localisation.tr((Object)"Information"), (Node)containerOverviewPanel);
        containerOverviewTab.setClosable(false);
        return containerOverviewTab;
    }

    private Tab createContainerEngineSettingsTab() {
        ContainerEngineSettingsPanel containerEngineSettingsPanel = new ContainerEngineSettingsPanel();
        containerEngineSettingsPanel.containerProperty().bind(((ContainerInformationPanel)((Object)this.getControl())).containerProperty());
        Bindings.bindContent(containerEngineSettingsPanel.getEngineSettings(), ((ContainerInformationPanel)((Object)this.getControl())).getEngineSettings());
        Tab engineSettingsTab = new Tab((String)Localisation.tr((Object)((String)Localisation.tr((Object)"Engine Settings"))), (Node)containerEngineSettingsPanel);
        engineSettingsTab.setClosable(false);
        return engineSettingsTab;
    }

    private Tab createContainerVerbsTab() {
        ContainerVerbsPanel containerVerbsPanel = new ContainerVerbsPanel();
        containerVerbsPanel.containerProperty().bind(((ContainerInformationPanel)((Object)this.getControl())).containerProperty());
        containerVerbsPanel.verbsProperty().bind(((ContainerInformationPanel)((Object)this.getControl())).verbsProperty());
        containerVerbsPanel.verbsManagerProperty().bind(((ContainerInformationPanel)((Object)this.getControl())).verbsManagerProperty());
        Tab verbsTab = new Tab((String)Localisation.tr((Object)((String)Localisation.tr((Object)"Verbs"))), (Node)containerVerbsPanel);
        verbsTab.setClosable(false);
        return verbsTab;
    }

    private Tab createContainerEngineToolsTab() {
        ContainerEngineToolsPanel containerEngineToolsPanel = new ContainerEngineToolsPanel();
        containerEngineToolsPanel.containerProperty().bind(((ContainerInformationPanel)((Object)this.getControl())).containerProperty());
        containerEngineToolsPanel.engineToolsProperty().bind(((ContainerInformationPanel)((Object)this.getControl())).engineToolsProperty());
        containerEngineToolsPanel.engineToolsManagerProperty().bind(((ContainerInformationPanel)((Object)this.getControl())).engineToolsManagerProperty());
        Tab engineToolsTab = new Tab((String)Localisation.tr((Object)"Engine tools"), (Node)containerEngineToolsPanel);
        engineToolsTab.setClosable(false);
        return engineToolsTab;
    }

    private Tab createContainerToolsTab() {
        ContainerToolsPanel containerToolsPanel = new ContainerToolsPanel();
        containerToolsPanel.containerProperty().bind(((ContainerInformationPanel)((Object)this.getControl())).containerProperty());
        containerToolsPanel.enginesManagerProperty().bind(((ContainerInformationPanel)((Object)this.getControl())).enginesManagerProperty());
        Tab containerToolsTab = new Tab((String)Localisation.tr((Object)"Tools"), (Node)containerToolsPanel);
        containerToolsTab.setClosable(false);
        return containerToolsTab;
    }
}

