/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.container.skin;

import java.util.List;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.containers.dto.ContainerDTO;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.container.control.ContainerEngineToolsPanel;
import org.phoenicis.javafx.dialogs.ErrorDialog;

public class ContainerEngineToolsPanelSkin
extends SkinBase<ContainerEngineToolsPanel, ContainerEngineToolsPanelSkin> {
    private final ObservableList<Button> toolButtons;

    public ContainerEngineToolsPanelSkin(ContainerEngineToolsPanel control) {
        super(control);
        this.toolButtons = new MappedList(control.getEngineToolScripts(), tool -> {
            Button toolButton = new Button(tool.getScriptName());
            toolButton.getStyleClass().addAll((Object[])new String[]{"toolButton"});
            toolButton.setStyle("-fx-background-image: url('" + tool.getIcon() + "');");
            toolButton.disableProperty().bind((ObservableValue)((ContainerEngineToolsPanel)((Object)((Object)this.getControl()))).lockToolsProperty());
            toolButton.setOnMouseClicked(event -> {
                ((ContainerEngineToolsPanel)((Object)((Object)((Object)this.getControl())))).setLockTools(true);
                ContainerDTO container = ((ContainerEngineToolsPanel)((Object)((Object)((Object)this.getControl())))).getContainer();
                ((ContainerEngineToolsPanel)((Object)((Object)((Object)this.getControl())))).getEngineToolsManager().runTool(container.getEngine().toLowerCase(), container.getName(), tool.getId().replaceAll("^.*\\.", ""), () -> ((ContainerEngineToolsPanel)((Object)((Object)((Object)((Object)this.getControl()))))).setLockTools(false), e -> Platform.runLater(() -> {
                    ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error")).withException((Exception)e).build();
                    errorDialog.showAndWait();
                }));
            });
            return toolButton;
        });
    }

    @Override
    public void initialise() {
        Text title = new Text((String)Localisation.tr((Object)"Engine tools"));
        title.getStyleClass().add((Object)"title");
        FlowPane toolButtonContainer = this.createToolButtonContainer();
        VBox toolsPane = new VBox(new Node[]{title, toolButtonContainer});
        toolsPane.getStyleClass().addAll((Object[])new String[]{"containerConfigurationPane"});
        ScrollPane scrollPane = new ScrollPane((Node)toolsPane);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setFitToWidth(true);
        this.getChildren().addAll((Object[])new Node[]{scrollPane});
    }

    private FlowPane createToolButtonContainer() {
        FlowPane toolsContentPane = new FlowPane();
        toolsContentPane.getStyleClass().add((Object)"grid");
        Bindings.bindContent((List)toolsContentPane.getChildren(), this.toolButtons);
        return toolsContentPane;
    }
}

