/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.container.skin;

import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.containers.dto.ContainerDTO;
import org.phoenicis.engines.EngineSetting;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.container.control.ContainerEngineSettingsPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerEngineSettingsPanelSkin
extends SkinBase<ContainerEngineSettingsPanel, ContainerEngineSettingsPanelSkin> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerEngineSettingsPanelSkin.class);

    public ContainerEngineSettingsPanelSkin(ContainerEngineSettingsPanel control) {
        super(control);
    }

    @Override
    public void initialise() {
        Text title = new Text((String)Localisation.tr((Object)"Engine Settings"));
        title.getStyleClass().add((Object)"title");
        GridPane engineSettingsGrid = new GridPane();
        engineSettingsGrid.getStyleClass().add((Object)"engine-settings-grid");
        ((ContainerEngineSettingsPanel)((Object)this.getControl())).containerProperty().addListener(invalidation -> this.updateEngineSettingsGrid(engineSettingsGrid));
        ((ContainerEngineSettingsPanel)((Object)this.getControl())).getEngineSettings().addListener(invalidation -> this.updateEngineSettingsGrid(engineSettingsGrid));
        this.updateEngineSettingsGrid(engineSettingsGrid);
        ScrollPane engineSettingsScrollPane = new ScrollPane((Node)engineSettingsGrid);
        engineSettingsScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        engineSettingsScrollPane.setFitToWidth(true);
        VBox.setVgrow((Node)engineSettingsScrollPane, (Priority)Priority.ALWAYS);
        VBox container = new VBox(new Node[]{title, engineSettingsScrollPane});
        container.getStyleClass().addAll((Object[])new String[]{"container-details-panel", "container-engine-settings-panel"});
        this.getChildren().setAll((Object[])new Node[]{container});
    }

    private void updateEngineSettingsGrid(GridPane engineSettingsGrid) {
        engineSettingsGrid.getChildren().clear();
        ContainerDTO container = ((ContainerEngineSettingsPanel)((Object)this.getControl())).getContainer();
        for (EngineSetting engineSetting : ((ContainerEngineSettingsPanel)((Object)this.getControl())).getEngineSettings()) {
            int row = engineSettingsGrid.getRowCount();
            Text engineSettingDescription = new Text(engineSetting.getText());
            engineSettingDescription.getStyleClass().add((Object)"captionTitle");
            ObservableList items = FXCollections.observableArrayList((Object[])engineSetting.getOptions());
            ComboBox engineSettingComboBox = new ComboBox(items);
            engineSettingComboBox.getStyleClass().add((Object)"engine-setting-combo-box");
            engineSettingComboBox.disableProperty().bind((ObservableValue)((ContainerEngineSettingsPanel)((Object)this.getControl())).lockEngineSettingsProperty());
            if (container != null) {
                try {
                    engineSettingComboBox.setValue((Object)engineSetting.getCurrentOption(container.getName()));
                }
                catch (Exception e) {
                    engineSettingComboBox.getSelectionModel().select(0);
                    LOGGER.warn(String.format("Could not fetch current option for engine setting \"%s\", will use default.", engineSetting.getText()));
                    LOGGER.debug("Caused by: ", (Throwable)e);
                }
                engineSettingComboBox.valueProperty().addListener(invalidation -> Platform.runLater(() -> {
                    ((ContainerEngineSettingsPanel)((Object)((Object)((Object)this.getControl())))).setLockEngineSettings(true);
                    engineSetting.setOption(container.getName(), items.indexOf(engineSettingComboBox.getValue()));
                    ((ContainerEngineSettingsPanel)((Object)((Object)((Object)this.getControl())))).setLockEngineSettings(false);
                }));
            }
            engineSettingsGrid.addRow(row, new Node[]{engineSettingDescription, engineSettingComboBox});
        }
    }
}

