/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.container.control;

import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.containers.ContainersManager;
import org.phoenicis.containers.dto.ContainerCategoryDTO;
import org.phoenicis.containers.dto.ContainerDTO;
import org.phoenicis.engines.EngineSetting;
import org.phoenicis.engines.EngineToolsManager;
import org.phoenicis.engines.EnginesManager;
import org.phoenicis.engines.VerbsManager;
import org.phoenicis.javafx.components.common.control.FeaturePanel;
import org.phoenicis.javafx.components.common.panelstates.None;
import org.phoenicis.javafx.components.common.panelstates.OpenDetailsPanel;
import org.phoenicis.javafx.components.container.skin.ContainersFeaturePanelSkin;
import org.phoenicis.javafx.dialogs.ErrorDialog;
import org.phoenicis.javafx.dialogs.SimpleConfirmDialog;
import org.phoenicis.javafx.settings.JavaFxSettingsManager;
import org.phoenicis.javafx.views.mainwindow.containers.ContainersFilter;
import org.phoenicis.repository.dto.ApplicationDTO;

public class ContainersFeaturePanel
extends FeaturePanel<ContainersFeaturePanel, ContainersFeaturePanelSkin> {
    private final ObjectProperty<ContainersFilter> filter = new SimpleObjectProperty();
    private final ObjectProperty<JavaFxSettingsManager> javaFxSettingsManager = new SimpleObjectProperty();
    private final ObservableList<ContainerCategoryDTO> categories = FXCollections.observableArrayList();
    private final ObjectProperty<ContainersManager> containersManager = new SimpleObjectProperty();
    private final ObjectProperty<EnginesManager> enginesManager = new SimpleObjectProperty();
    private final ObjectProperty<VerbsManager> verbsManager = new SimpleObjectProperty();
    private final ObjectProperty<EngineToolsManager> engineToolsManager = new SimpleObjectProperty();
    private final ObservableMap<String, List<EngineSetting>> engineSettings = FXCollections.observableHashMap();
    private final ObservableMap<String, ApplicationDTO> verbs = FXCollections.observableHashMap();
    private final ObservableMap<String, ApplicationDTO> engineTools = FXCollections.observableHashMap();
    private final ObjectProperty<ContainerDTO> selectedContainer = new SimpleObjectProperty();
    private final ObjectProperty<OpenDetailsPanel> openedDetailsPanel = new SimpleObjectProperty((Object)new None());

    @Override
    public ContainersFeaturePanelSkin createSkin() {
        return new ContainersFeaturePanelSkin(this);
    }

    public void deleteContainer(ContainerDTO container) {
        SimpleConfirmDialog confirmMessage = SimpleConfirmDialog.builder().withTitle(Localisation.tr((String)"Delete {0} container", (Object)container.getName())).withMessage(Localisation.tr((String)"Are you sure you want to delete the {0} container?", (Object)container.getName())).withOwner(this.getScene().getWindow()).withYesCallback(() -> {
            this.getContainersManager().deleteContainer(container, unused -> Platform.runLater(() -> this.setSelectedContainer(null)), e -> Platform.runLater(() -> {
                ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error")).withException((Exception)e).withOwner(this.getScene().getWindow()).build();
                errorDialog.showAndWait();
            }));
            this.getContainersManager().fetchContainers(containerCategories -> Platform.runLater(() -> this.categories.setAll((Collection)containerCategories)), e -> Platform.runLater(() -> {
                ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Loading containers failed.")).withException((Exception)e).withOwner(this.getScene().getWindow()).build();
                errorDialog.showAndWait();
            }));
        }).build();
        confirmMessage.showAndCallback();
    }

    public void changeEngineVersion(ContainerDTO container) {
        EnginesManager enginesManager = this.getEnginesManager();
        if (enginesManager != null) {
            String engineId = container.getEngine().toLowerCase();
            enginesManager.getEngine(engineId, engine -> engine.changeVersion(container.getName()), exception -> Platform.runLater(() -> {
                ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Error during engine version change")).withException((Exception)exception).withOwner(this.getScene().getWindow()).build();
                errorDialog.showAndWait();
            }));
        }
    }

    public void openFileBrowser(ContainerDTO container) {
        try {
            File containerDir = new File(container.getPath());
            EventQueue.invokeLater(() -> {
                try {
                    Desktop.getDesktop().open(containerDir);
                }
                catch (IOException e) {
                    Platform.runLater(() -> {
                        ErrorDialog errorDialog = ErrorDialog.builder().withMessage(Localisation.tr((String)"Cannot open container {0} in file browser", (Object)container.getPath())).withException(e).withOwner(this.getScene().getWindow()).build();
                        errorDialog.showAndWait();
                    });
                }
            });
        }
        catch (IllegalArgumentException e) {
            Platform.runLater(() -> {
                ErrorDialog errorDialog = ErrorDialog.builder().withMessage(Localisation.tr((String)"Cannot open container {0} in file browser", (Object)container.getPath())).withException(e).withOwner(this.getScene().getWindow()).build();
                errorDialog.showAndWait();
            });
        }
    }

    public ContainersFilter getFilter() {
        return (ContainersFilter)this.filter.get();
    }

    public ObjectProperty<ContainersFilter> filterProperty() {
        return this.filter;
    }

    public void setFilter(ContainersFilter filter) {
        this.filter.set((Object)filter);
    }

    public JavaFxSettingsManager getJavaFxSettingsManager() {
        return (JavaFxSettingsManager)this.javaFxSettingsManager.get();
    }

    public ObjectProperty<JavaFxSettingsManager> javaFxSettingsManagerProperty() {
        return this.javaFxSettingsManager;
    }

    public void setJavaFxSettingsManager(JavaFxSettingsManager javaFxSettingsManager) {
        this.javaFxSettingsManager.set((Object)javaFxSettingsManager);
    }

    public ObservableList<ContainerCategoryDTO> getCategories() {
        return this.categories;
    }

    public ContainersManager getContainersManager() {
        return (ContainersManager)this.containersManager.get();
    }

    public ObjectProperty<ContainersManager> containersManagerProperty() {
        return this.containersManager;
    }

    public void setContainersManager(ContainersManager containersManager) {
        this.containersManager.set((Object)containersManager);
    }

    public EnginesManager getEnginesManager() {
        return (EnginesManager)this.enginesManager.get();
    }

    public ObjectProperty<EnginesManager> enginesManagerProperty() {
        return this.enginesManager;
    }

    public void setEnginesManager(EnginesManager enginesManager) {
        this.enginesManager.set((Object)enginesManager);
    }

    public VerbsManager getVerbsManager() {
        return (VerbsManager)this.verbsManager.get();
    }

    public ObjectProperty<VerbsManager> verbsManagerProperty() {
        return this.verbsManager;
    }

    public void setVerbsManager(VerbsManager verbsManager) {
        this.verbsManager.set((Object)verbsManager);
    }

    public EngineToolsManager getEngineToolsManager() {
        return (EngineToolsManager)this.engineToolsManager.get();
    }

    public ObjectProperty<EngineToolsManager> engineToolsManagerProperty() {
        return this.engineToolsManager;
    }

    public void setEngineToolsManager(EngineToolsManager engineToolsManager) {
        this.engineToolsManager.set((Object)engineToolsManager);
    }

    public ObservableMap<String, List<EngineSetting>> getEngineSettings() {
        return this.engineSettings;
    }

    public ObservableMap<String, ApplicationDTO> getVerbs() {
        return this.verbs;
    }

    public ObservableMap<String, ApplicationDTO> getEngineTools() {
        return this.engineTools;
    }

    public ContainerDTO getSelectedContainer() {
        return (ContainerDTO)this.selectedContainer.get();
    }

    public ObjectProperty<ContainerDTO> selectedContainerProperty() {
        return this.selectedContainer;
    }

    public void setSelectedContainer(ContainerDTO selectedContainer) {
        this.selectedContainer.set((Object)selectedContainer);
    }

    public OpenDetailsPanel getOpenedDetailsPanel() {
        return (OpenDetailsPanel)this.openedDetailsPanel.get();
    }

    public ObjectProperty<OpenDetailsPanel> openedDetailsPanelProperty() {
        return this.openedDetailsPanel;
    }

    public void setOpenedDetailsPanel(OpenDetailsPanel action) {
        this.openedDetailsPanel.setValue((Object)action);
    }

    @Override
    public void closeDetailsPanel() {
        this.setSelectedContainer(null);
        this.setOpenedDetailsPanel(new None());
    }
}

