/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.container.control;

import java.util.Comparator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import org.phoenicis.containers.dto.ContainerDTO;
import org.phoenicis.engines.VerbsManager;
import org.phoenicis.javafx.components.common.control.ControlBase;
import org.phoenicis.javafx.components.container.skin.ContainerVerbsPanelSkin;
import org.phoenicis.javafx.utils.CollectionBindings;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.phoenicis.repository.dto.ScriptDTO;

public class ContainerVerbsPanel
extends ControlBase<ContainerVerbsPanel, ContainerVerbsPanelSkin> {
    private final ObjectProperty<ContainerDTO> container = new SimpleObjectProperty();
    private final ObjectProperty<VerbsManager> verbsManager = new SimpleObjectProperty();
    private final ObjectProperty<ApplicationDTO> verbs = new SimpleObjectProperty();
    private final SortedList<ScriptDTO> verbScripts;
    private final BooleanProperty lockVerbs = new SimpleBooleanProperty();

    public ContainerVerbsPanel() {
        this.verbScripts = CollectionBindings.mapToList(this.verbsProperty(), ApplicationDTO::getScripts).sorted(Comparator.comparing(ScriptDTO::getScriptName));
    }

    @Override
    public ContainerVerbsPanelSkin createSkin() {
        return new ContainerVerbsPanelSkin(this);
    }

    public ContainerDTO getContainer() {
        return (ContainerDTO)this.container.get();
    }

    public ObjectProperty<ContainerDTO> containerProperty() {
        return this.container;
    }

    public void setContainer(ContainerDTO container) {
        this.container.set((Object)container);
    }

    public VerbsManager getVerbsManager() {
        return (VerbsManager)this.verbsManager.get();
    }

    public ObjectProperty<VerbsManager> verbsManagerProperty() {
        return this.verbsManager;
    }

    public void setVerbsManager(VerbsManager verbsManager) {
        this.verbsManager.set((Object)verbsManager);
    }

    public ApplicationDTO getVerbs() {
        return (ApplicationDTO)this.verbs.get();
    }

    public ObjectProperty<ApplicationDTO> verbsProperty() {
        return this.verbs;
    }

    public void setVerbs(ApplicationDTO verbs) {
        this.verbs.set((Object)verbs);
    }

    public ObservableList<ScriptDTO> getVerbScripts() {
        return this.verbScripts;
    }

    public boolean isLockVerbs() {
        return this.lockVerbs.get();
    }

    public BooleanProperty lockVerbsProperty() {
        return this.lockVerbs;
    }

    public void setLockVerbs(boolean lockVerbs) {
        this.lockVerbs.set(lockVerbs);
    }
}

