/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.widgets.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.phoenicis.containers.dto.ContainerDTO;
import org.phoenicis.engines.dto.EngineVersionDTO;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetAdditionalInformation;
import org.phoenicis.javafx.views.mainwindow.installations.dto.InstallationDTO;
import org.phoenicis.library.dto.ShortcutDTO;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListWidgetElement<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListWidgetElement.class);
    private static URI DEFAULT_MINIATURE;
    private static URI WINE_MINIATURE;
    private static URI CONTAINER_MINIATURE;
    private E item;
    private URI defaultIconUri;
    private Optional<URI> iconUri;
    private String title;
    private List<ListWidgetAdditionalInformation> additionalInformation;
    private List<ListWidgetAdditionalInformation> detailedInformation;
    private boolean enabled;

    public ListWidgetElement(E item, Optional<URI> iconUri, URI defaultIconUri, String title, List<ListWidgetAdditionalInformation> additionalInformation, List<ListWidgetAdditionalInformation> detailedInformation) {
        this(item, iconUri, defaultIconUri, title, additionalInformation, detailedInformation, true);
    }

    public ListWidgetElement(E item, Optional<URI> iconUri, URI defaultIconUri, String title, List<ListWidgetAdditionalInformation> additionalInformation, List<ListWidgetAdditionalInformation> detailedInformation, boolean enabled) {
        this.item = item;
        this.defaultIconUri = defaultIconUri;
        this.iconUri = iconUri;
        this.title = title;
        this.additionalInformation = additionalInformation;
        this.detailedInformation = detailedInformation;
        this.enabled = enabled;
    }

    public static ListWidgetElement<ApplicationDTO> create(ApplicationDTO application) {
        return new ListWidgetElement<ApplicationDTO>(application, application.getMainMiniature(), DEFAULT_MINIATURE, application.getName(), Collections.emptyList(), Collections.emptyList());
    }

    public static ListWidgetElement<ContainerDTO> create(ContainerDTO container) {
        ArrayList<BufferedImage> miniatures = new ArrayList<BufferedImage>();
        int maxSegments = 4;
        int currentSegment = 0;
        for (ShortcutDTO shortcutDTO : container.getInstalledShortcuts()) {
            if (currentSegment >= 4) break;
            try {
                miniatures.add(ImageIO.read(shortcutDTO.getMiniature().toURL()));
                ++currentSegment;
            }
            catch (IOException e) {
                LOGGER.warn(String.format("Could not read miniature for shortcut \"%s\"", shortcutDTO.getInfo().getName()), (Throwable)e);
            }
        }
        BufferedImage segmentedMiniature = ListWidgetElement.createSegmentedMiniature(miniatures);
        Optional<URI> shortcutMiniature = ListWidgetElement.saveBufferedImage(segmentedMiniature, container.getName());
        return new ListWidgetElement<ContainerDTO>(container, shortcutMiniature, CONTAINER_MINIATURE, container.getName(), Collections.emptyList(), Collections.emptyList());
    }

    public static ListWidgetElement<ShortcutDTO> create(ShortcutDTO shortcut) {
        return new ListWidgetElement<ShortcutDTO>(shortcut, Optional.ofNullable(shortcut.getMiniature()), DEFAULT_MINIATURE, shortcut.getInfo().getName(), Collections.emptyList(), Collections.emptyList());
    }

    public static ListWidgetElement<InstallationDTO> create(InstallationDTO installation) {
        return new ListWidgetElement<InstallationDTO>(installation, Optional.ofNullable(installation.getMiniature()), DEFAULT_MINIATURE, installation.getName(), Collections.emptyList(), Collections.emptyList());
    }

    public static ListWidgetElement<EngineVersionDTO> create(EngineVersionDTO engineVersion, boolean installed) {
        return new ListWidgetElement<EngineVersionDTO>(engineVersion, Optional.empty(), WINE_MINIATURE, engineVersion.getVersion(), Collections.emptyList(), Collections.emptyList(), installed);
    }

    public E getItem() {
        return this.item;
    }

    public URI getIconUri() {
        return this.iconUri.orElse(this.defaultIconUri);
    }

    public String getTitle() {
        return this.title;
    }

    public List<ListWidgetAdditionalInformation> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public List<ListWidgetAdditionalInformation> getDetailedInformation() {
        return this.detailedInformation;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static BufferedImage createSegmentedMiniature(List<BufferedImage> miniatures) {
        if (!miniatures.isEmpty()) {
            int width = miniatures.get(0).getWidth();
            int height = miniatures.get(0).getHeight();
            BufferedImage result = new BufferedImage(width, height, 2);
            int numberOfSegments = miniatures.size();
            int segmentWidth = width / numberOfSegments;
            int offset = (width - segmentWidth) / 2;
            ArrayList segments = new ArrayList();
            miniatures.forEach(miniature -> segments.add(miniature.getSubimage(offset, 0, offset + segmentWidth, height)));
            Graphics2D graphics = result.createGraphics();
            for (int i = 0; i < segments.size(); ++i) {
                graphics.drawImage((Image)segments.get(i), 0 + i * segmentWidth, 0, null);
            }
            return result;
        }
        return null;
    }

    private static Optional<URI> saveBufferedImage(BufferedImage bufferedImage, String name) {
        if (bufferedImage != null) {
            try {
                Path temp = Files.createTempFile(name, ".png", new FileAttribute[0]).toAbsolutePath();
                File tempFile = temp.toFile();
                tempFile.deleteOnExit();
                ImageIO.write((RenderedImage)bufferedImage, "png", tempFile);
                return Optional.of(temp.toUri());
            }
            catch (IOException e) {
                LOGGER.warn(String.format("Could not create container miniature for container \"%s\"", name), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    static {
        try {
            DEFAULT_MINIATURE = ListWidgetElement.class.getResource("defaultMiniature.png").toURI();
            WINE_MINIATURE = ListWidgetElement.class.getResource("wineMiniature.png").toURI();
            CONTAINER_MINIATURE = ListWidgetElement.class.getResource("containerMiniature.png").toURI();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

