/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.widgets.skin;

import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import org.phoenicis.javafx.components.common.behavior.ListWidgetSelectorBehavior;
import org.phoenicis.javafx.components.common.skin.BehaviorSkinBase;
import org.phoenicis.javafx.components.common.widgets.control.ListWidgetSelector;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetType;

public class ListWidgetSelectorSkin
extends BehaviorSkinBase<ListWidgetSelector, ListWidgetSelectorSkin, ListWidgetSelectorBehavior> {
    private ToggleButton iconsListButton;
    private ToggleButton compactListButton;
    private ToggleButton detailsListButton;

    public ListWidgetSelectorSkin(ListWidgetSelector control) {
        super(control);
    }

    @Override
    public void initialise() {
        ToggleGroup toggleGroup = new ToggleGroup();
        this.iconsListButton = new ToggleButton();
        this.iconsListButton.setToggleGroup(toggleGroup);
        this.iconsListButton.getStyleClass().addAll((Object[])new String[]{"listIcon", "iconsList"});
        this.compactListButton = new ToggleButton();
        this.compactListButton.setToggleGroup(toggleGroup);
        this.compactListButton.getStyleClass().addAll((Object[])new String[]{"listIcon", "compactList"});
        this.detailsListButton = new ToggleButton();
        this.detailsListButton.setToggleGroup(toggleGroup);
        this.detailsListButton.getStyleClass().addAll((Object[])new String[]{"listIcon", "detailsList"});
        HBox container = new HBox(new Node[]{this.iconsListButton, this.compactListButton, this.detailsListButton});
        container.getStyleClass().add((Object)"listChooser");
        this.getChildren().addAll((Object[])new Node[]{container});
    }

    @Override
    public ListWidgetSelectorBehavior createBehavior() {
        return new ListWidgetSelectorBehavior((ListWidgetSelector)((Object)this.getControl()), this);
    }

    public ToggleButton getListButton(ListWidgetType type) {
        switch (type) {
            case COMPACT_LIST: {
                return this.compactListButton;
            }
            case DETAILS_LIST: {
                return this.detailsListButton;
            }
            case ICONS_LIST: {
                return this.iconsListButton;
            }
        }
        throw new IllegalArgumentException("Unknown ListWidgetType: " + type.toString());
    }

    public ToggleButton getIconsListButton() {
        return this.iconsListButton;
    }

    public ToggleButton getCompactListButton() {
        return this.compactListButton;
    }

    public ToggleButton getDetailsListButton() {
        return this.detailsListButton;
    }
}

