/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.widgets.icons.skin;

import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.common.widgets.icons.control.IconsListElement;
import org.phoenicis.javafx.components.common.widgets.icons.control.IconsListWidget;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetSelection;

public class IconsListWidgetSkin<E>
extends SkinBase<IconsListWidget<E>, IconsListWidgetSkin<E>> {
    private final ObservableList<IconsListElement<E>> mappedElements = new MappedList(((IconsListWidget)((Object)this.getControl())).getElements(), value -> {
        IconsListElement newElement = new IconsListElement(value);
        newElement.setOnMouseClicked(event -> ((IconsListWidget)((Object)((Object)((Object)this.getControl())))).setSelectedElement(new ListWidgetSelection(value, (MouseEvent)event)));
        return newElement;
    });

    public IconsListWidgetSkin(IconsListWidget<E> control) {
        super(control);
    }

    @Override
    public void initialise() {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.getStyleClass().add((Object)"iconListWidget");
        scrollPane.setCache(true);
        scrollPane.setCacheHint(CacheHint.QUALITY);
        scrollPane.setContent((Node)this.createContent(scrollPane));
        this.getChildren().addAll((Object[])new Node[]{scrollPane});
    }

    private FlowPane createContent(ScrollPane container) {
        FlowPane content = new FlowPane();
        content.prefWidthProperty().bind((ObservableValue)container.widthProperty());
        content.setPrefHeight(0.0);
        Bindings.bindContent((List)content.getChildren(), this.mappedElements);
        ((IconsListWidget)((Object)this.getControl())).selectedElementProperty().addListener((observable, oldValue, newValue) -> {
            this.updateOldSelection((ListWidgetSelection<E>)oldValue);
            this.updateNewSelection((ListWidgetSelection<E>)newValue);
        });
        this.updateNewSelection(((IconsListWidget)((Object)this.getControl())).getSelectedElement());
        return content;
    }

    private void updateOldSelection(ListWidgetSelection<E> oldSelection) {
        Optional.ofNullable(oldSelection).map(ListWidgetSelection::getSelection).ifPresent(selection -> {
            int oldValueIndex = ((IconsListWidget)((Object)((Object)this.getControl()))).getElements().indexOf(selection);
            if (this.mappedElements.size() > oldValueIndex && oldValueIndex != -1) {
                IconsListElement oldElement = (IconsListElement)((Object)((Object)this.mappedElements.get(oldValueIndex)));
                oldElement.setSelected(false);
            }
        });
    }

    private void updateNewSelection(ListWidgetSelection<E> newSelection) {
        Optional.ofNullable(newSelection).map(ListWidgetSelection::getSelection).ifPresent(selection -> {
            int newValueIndex = ((IconsListWidget)((Object)((Object)this.getControl()))).getElements().indexOf(selection);
            IconsListElement newElement = (IconsListElement)((Object)((Object)this.mappedElements.get(newValueIndex)));
            newElement.setSelected(true);
        });
    }
}

