/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.widgets.icons.skin;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.common.widgets.icons.control.IconsListElement;

public class IconsListElementSkin<E>
extends SkinBase<IconsListElement<E>, IconsListElementSkin<E>> {
    private static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");

    public IconsListElementSkin(IconsListElement<E> control) {
        super(control);
    }

    @Override
    public void initialise() {
        VBox container = new VBox(new Node[]{this.createMiniature(), this.createLabel()});
        container.getStyleClass().add((Object)"iconListElement");
        container.widthProperty().addListener((observable, oldValue, newValue) -> container.setClip((Node)new Rectangle(container.getWidth(), container.getHeight())));
        container.heightProperty().addListener((observable, oldValue, newValue) -> container.setClip((Node)new Rectangle(container.getWidth(), container.getHeight())));
        ((IconsListElement)((Object)this.getControl())).selectedProperty().addListener(invalidation -> container.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, ((IconsListElement)((Object)((Object)this.getControl()))).isSelected()));
        container.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, ((IconsListElement)((Object)this.getControl())).isSelected());
        this.getChildren().addAll((Object[])new Node[]{container});
    }

    private Label createLabel() {
        Label label = new Label();
        label.getStyleClass().add((Object)"iconListMiniatureLabel");
        label.textProperty().bind((ObservableValue)((IconsListElement)((Object)this.getControl())).titleProperty());
        return label;
    }

    private Region createMiniature() {
        Region miniature = new Region();
        miniature.getStyleClass().add((Object)"iconListMiniatureImage");
        miniature.styleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> String.format("-fx-background-image: url(\"%s\");", ((IconsListElement)((Object)((Object)this.getControl()))).getMiniatureUri().toString()), (Observable[])new Observable[]{((IconsListElement)((Object)this.getControl())).miniatureUriProperty()}));
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)((IconsListElement)((Object)this.getControl())).titleProperty());
        Tooltip.install((Node)miniature, (Tooltip)tooltip);
        ((IconsListElement)((Object)this.getControl())).enabledProperty().addListener(invalidation -> this.updateEnabled(miniature));
        this.updateEnabled(miniature);
        return miniature;
    }

    private void updateEnabled(Region miniature) {
        if (!((IconsListElement)((Object)this.getControl())).isEnabled()) {
            ColorAdjust grayScale = new ColorAdjust();
            grayScale.setSaturation(-1.0);
            miniature.setEffect((Effect)grayScale);
        } else {
            miniature.setEffect(null);
        }
    }
}

