/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.widgets.details.skin;

import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.common.widgets.details.control.DetailsListElement;
import org.phoenicis.javafx.components.common.widgets.details.control.DetailsListWidget;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetSelection;

public class DetailsListWidgetSkin<E>
extends SkinBase<DetailsListWidget<E>, DetailsListWidgetSkin<E>> {
    private final ObservableList<DetailsListElement<E>> mappedElements = new MappedList(((DetailsListWidget)((Object)this.getControl())).getElements(), value -> {
        DetailsListElement newElement = new DetailsListElement(value);
        newElement.setOnMouseClicked(event -> ((DetailsListWidget)((Object)((Object)((Object)this.getControl())))).setSelectedElement(new ListWidgetSelection(value, (MouseEvent)event)));
        return newElement;
    });

    public DetailsListWidgetSkin(DetailsListWidget<E> control) {
        super(control);
    }

    @Override
    public void initialise() {
        ListView container = new ListView();
        container.getStyleClass().addAll((Object[])new String[]{"listWidget", "detailsListWidget"});
        container.setPrefWidth(0.0);
        container.setPrefHeight(0.0);
        container.setCellFactory(param -> {
            ListCell listCell = new ListCell<DetailsListElement<E>>(){

                public void updateItem(DetailsListElement<E> item, boolean empty) {
                    super.updateItem(item, empty);
                    if (!empty && item != null) {
                        this.setGraphic((Node)item);
                    } else {
                        this.setGraphic(null);
                    }
                }
            };
            listCell.getStyleClass().addAll((Object[])new String[]{"detailsListElement"});
            return listCell;
        });
        Bindings.bindContent((List)container.getItems(), this.mappedElements);
        ((DetailsListWidget)((Object)this.getControl())).selectedElementProperty().addListener((observable, oldValue, newValue) -> {
            this.updateOldSelection((ListView<DetailsListElement<E>>)container, (ListWidgetSelection<E>)oldValue);
            this.updateNewSelection((ListView<DetailsListElement<E>>)container, (ListWidgetSelection<E>)newValue);
        });
        this.updateNewSelection(container, ((DetailsListWidget)((Object)this.getControl())).getSelectedElement());
        this.getChildren().addAll((Object[])new Node[]{container});
    }

    private void updateOldSelection(ListView<DetailsListElement<E>> container, ListWidgetSelection<E> oldSelection) {
        Optional.ofNullable(oldSelection).map(ListWidgetSelection::getSelection).ifPresent(selection -> {
            int oldValueIndex = ((DetailsListWidget)((Object)((Object)this.getControl()))).getElements().indexOf(selection);
            if (this.mappedElements.size() > oldValueIndex && oldValueIndex != -1) {
                container.getSelectionModel().clearSelection(oldValueIndex);
            }
        });
    }

    private void updateNewSelection(ListView<DetailsListElement<E>> container, ListWidgetSelection<E> newSelection) {
        Optional.ofNullable(newSelection).map(ListWidgetSelection::getSelection).ifPresent(selection -> {
            int newValueIndex = ((DetailsListWidget)((Object)((Object)this.getControl()))).getElements().indexOf(selection);
            container.getSelectionModel().select(newValueIndex);
        });
    }
}

