/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.widgets.control;

import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.phoenicis.javafx.components.common.control.ControlBase;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetElement;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetSelection;

public abstract class ListWidgetBase<E, C extends ListWidgetBase<E, C, S>, S extends SkinBase<C, S>>
extends ControlBase<C, S> {
    private final ObservableList<ListWidgetElement<E>> elements;
    private final ObjectProperty<ListWidgetSelection<E>> selectedElement;

    protected ListWidgetBase(ObservableList<ListWidgetElement<E>> elements, ObjectProperty<ListWidgetSelection<E>> selectedElement) {
        this.elements = elements;
        this.selectedElement = selectedElement;
    }

    public ObservableList<ListWidgetElement<E>> getElements() {
        return this.elements;
    }

    public ListWidgetSelection<E> getSelectedElement() {
        return (ListWidgetSelection)this.selectedElement.get();
    }

    public ObjectProperty<ListWidgetSelection<E>> selectedElementProperty() {
        return this.selectedElement;
    }

    public void setSelectedElement(ListWidgetSelection<E> selectedElement) {
        this.selectedElement.set(selectedElement);
    }

    public void select(E innerElement, MouseEvent event) {
        ListWidgetElement foundElement = this.elements.stream().filter(element -> element.getItem() == innerElement).findFirst().orElseThrow(() -> new IllegalArgumentException("The searched element is not contained inside the list widget"));
        this.setSelectedElement(new ListWidgetSelection(foundElement, event));
    }

    public void select(E innerElement) {
        MouseEvent event = new MouseEvent(MouseEvent.MOUSE_CLICKED, 0.0, 0.0, 0.0, 0.0, MouseButton.PRIMARY, 1, false, false, false, false, false, false, false, false, false, false, null);
        this.select(innerElement, event);
    }

    public void deselect() {
        this.setSelectedElement(null);
    }
}

