/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.components.common.widgets.compact.skin;

import java.util.List;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.components.common.skin.SkinBase;
import org.phoenicis.javafx.components.common.widgets.compact.control.CompactListElement;
import org.phoenicis.javafx.components.common.widgets.compact.control.CompactListWidget;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetSelection;

public class CompactListWidgetSkin<E>
extends SkinBase<CompactListWidget<E>, CompactListWidgetSkin<E>> {
    private final ObservableList<CompactListElement<E>> mappedElements = new MappedList(((CompactListWidget)((Object)this.getControl())).getElements(), value -> {
        CompactListElement newElement = new CompactListElement(value);
        newElement.setOnMouseClicked(event -> ((CompactListWidget)((Object)((Object)((Object)this.getControl())))).setSelectedElement(new ListWidgetSelection(value, (MouseEvent)event)));
        return newElement;
    });

    public CompactListWidgetSkin(CompactListWidget<E> control) {
        super(control);
    }

    @Override
    public void initialise() {
        ListView container = new ListView();
        container.getStyleClass().addAll((Object[])new String[]{"listWidget", "compactListWidget"});
        container.setPrefWidth(0.0);
        container.setPrefHeight(0.0);
        container.setCellFactory(param -> {
            ListCell listCell = new ListCell<CompactListElement<E>>(){

                public void updateItem(CompactListElement<E> item, boolean empty) {
                    super.updateItem(item, empty);
                    if (!empty && item != null) {
                        this.setGraphic((Node)item);
                    } else {
                        this.setGraphic(null);
                    }
                }
            };
            listCell.getStyleClass().addAll((Object[])new String[]{"compactListElement"});
            return listCell;
        });
        Bindings.bindContent((List)container.getItems(), this.mappedElements);
        ((CompactListWidget)((Object)this.getControl())).selectedElementProperty().addListener((observable, oldValue, newValue) -> {
            this.updateOldSelection((ListView<CompactListElement<E>>)container, (ListWidgetSelection<E>)oldValue);
            this.updateNewSelection((ListView<CompactListElement<E>>)container, (ListWidgetSelection<E>)newValue);
        });
        this.updateNewSelection(container, ((CompactListWidget)((Object)this.getControl())).getSelectedElement());
        this.getChildren().addAll((Object[])new Node[]{container});
    }

    private void updateOldSelection(ListView<CompactListElement<E>> container, ListWidgetSelection<E> oldSelection) {
        Optional.ofNullable(oldSelection).map(ListWidgetSelection::getSelection).ifPresent(selection -> {
            int oldValueIndex = ((CompactListWidget)((Object)((Object)this.getControl()))).getElements().indexOf(selection);
            if (this.mappedElements.size() > oldValueIndex && oldValueIndex != -1) {
                container.getSelectionModel().clearSelection(oldValueIndex);
            }
        });
    }

    private void updateNewSelection(ListView<CompactListElement<E>> container, ListWidgetSelection<E> newSelection) {
        Optional.ofNullable(newSelection).map(ListWidgetSelection::getSelection).ifPresent(selection -> {
            int newValueIndex = ((CompactListWidget)((Object)((Object)this.getControl()))).getElements().indexOf(selection);
            container.getSelectionModel().select(newValueIndex);
        });
    }
}

